/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.IOParameter;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckNoObjectsActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckObjectUnitConsistencyActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckObjectsNumberActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckVersionActionHandler;
import fr.gouv.vitam.worker.core.handler.ExtractSedaActionHandler;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class CheckDataObjectPackageActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckDataObjectPackageActionHandler.class);
    private static final String HANDLER_ID = "CHECK_DATAOBJECTPACKAGE";
    private static final int CHECK_NO_OBJECT_INPUT_RANK = 0;
    private final MetaDataClientFactory metaDataClientFactory;
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final SedaUtilsFactory sedaUtilsFactory;
    private final CheckNoObjectsActionHandler checkNoObjectsActionHandler;
    private final CheckObjectsNumberActionHandler checkObjectsNumberActionHandler;
    private final ExtractSedaActionHandler extractSedaActionHandler;
    private final CheckObjectUnitConsistencyActionHandler checkObjectUnitConsistencyActionHandler;

    public CheckDataObjectPackageActionHandler(CheckNoObjectsActionHandler checkNoObjectsActionHandler, CheckObjectsNumberActionHandler checkObjectsNumberActionHandler, ExtractSedaActionHandler extractSedaActionHandler, CheckObjectUnitConsistencyActionHandler checkObjectUnitConsistencyActionHandler) {
        this(MetaDataClientFactory.getInstance(), AdminManagementClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), SedaUtilsFactory.getInstance(), checkNoObjectsActionHandler, checkObjectsNumberActionHandler, extractSedaActionHandler, checkObjectUnitConsistencyActionHandler);
    }

    public CheckDataObjectPackageActionHandler(MetaDataClientFactory metaDataClientFactory, AdminManagementClientFactory adminManagementClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, SedaUtilsFactory sedaUtilsFactory, CheckNoObjectsActionHandler checkNoObjectsActionHandler, CheckObjectsNumberActionHandler checkObjectsNumberActionHandler, ExtractSedaActionHandler extractSedaActionHandler, CheckObjectUnitConsistencyActionHandler checkObjectUnitConsistencyActionHandler) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.sedaUtilsFactory = sedaUtilsFactory;
        this.checkNoObjectsActionHandler = checkNoObjectsActionHandler;
        this.checkObjectsNumberActionHandler = checkObjectsNumberActionHandler;
        this.extractSedaActionHandler = extractSedaActionHandler;
        this.checkObjectUnitConsistencyActionHandler = checkObjectUnitConsistencyActionHandler;
    }

    public static String getId() {
        return HANDLER_ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        ItemStatus itemStatus;
        block39: {
            itemStatus = new ItemStatus(HANDLER_ID);
            try {
                if (Boolean.valueOf((String)handlerIO.getInput(0)).booleanValue()) {
                    Stopwatch checkNoObject = Stopwatch.createStarted();
                    ItemStatus checkNoObjectStatus = this.checkNoObjectsActionHandler.execute(params, handlerIO);
                    PerformanceLogger.getInstance().log("STP_INGEST_CONTROL_SIP", HANDLER_ID, "checkNoObject", checkNoObject.elapsed(TimeUnit.MILLISECONDS));
                    itemStatus.setItemsStatus(CheckNoObjectsActionHandler.getId(), checkNoObjectStatus);
                    Stopwatch checkObjectNumber = Stopwatch.createStarted();
                    ItemStatus checkObjectNumberStatus = this.checkObjectsNumberActionHandler.execute(params, handlerIO);
                    PerformanceLogger.getInstance().log("STP_INGEST_CONTROL_SIP", HANDLER_ID, "checkObjectNumber", checkObjectNumber.elapsed(TimeUnit.MILLISECONDS));
                    itemStatus.setItemsStatus(CheckObjectsNumberActionHandler.getId(), checkObjectNumberStatus);
                    Stopwatch extractSeda = Stopwatch.createStarted();
                    ItemStatus extractSedaStatus = this.extractSedaActionHandler.execute(params, handlerIO);
                    PerformanceLogger.getInstance().log("STP_INGEST_CONTROL_SIP", HANDLER_ID, "extractSeda", extractSeda.elapsed(TimeUnit.MILLISECONDS));
                    itemStatus.setItemsStatus(ExtractSedaActionHandler.getId(), extractSedaStatus);
                    if (extractSedaStatus.shallStop(true)) {
                        this.resetItemStatusMeter(itemStatus);
                        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
                    }
                    break block39;
                }
                try (CheckVersionActionHandler checkVersionActionHandler = new CheckVersionActionHandler(this.sedaUtilsFactory);
                     CheckObjectsNumberActionHandler checkObjectsNumberActionHandler = new CheckObjectsNumberActionHandler(this.sedaUtilsFactory);
                     ExtractSedaActionHandler extractSedaActionHandler = new ExtractSedaActionHandler(this.metaDataClientFactory, this.adminManagementClientFactory, this.logbookLifeCyclesClientFactory);
                     CheckObjectUnitConsistencyActionHandler checkObjectUnitConsistencyActionHandler = new CheckObjectUnitConsistencyActionHandler();){
                    Stopwatch checkVersion = Stopwatch.createStarted();
                    ItemStatus checkVersionStatus = checkVersionActionHandler.execute(params, handlerIO);
                    PerformanceLogger.getInstance().log("STP_INGEST_CONTROL_SIP", HANDLER_ID, "checkVersion", checkVersion.elapsed(TimeUnit.MILLISECONDS));
                    itemStatus.setItemsStatus(CheckVersionActionHandler.getId(), checkVersionStatus);
                    if (checkVersionStatus.shallStop(true)) {
                        this.resetItemStatusMeter(itemStatus);
                        ItemStatus itemStatus2 = new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
                        return itemStatus2;
                    }
                    Stopwatch checkObjectNumber = Stopwatch.createStarted();
                    ItemStatus checkObjectNumberStatus = checkObjectsNumberActionHandler.execute(params, handlerIO);
                    PerformanceLogger.getInstance().log("STP_INGEST_CONTROL_SIP", HANDLER_ID, "checkObjectNumber", checkObjectNumber.elapsed(TimeUnit.MILLISECONDS));
                    itemStatus.setItemsStatus(CheckObjectsNumberActionHandler.getId(), checkObjectNumberStatus);
                    if (checkObjectNumberStatus.shallStop(true)) {
                        this.resetItemStatusMeter(itemStatus);
                        ItemStatus itemStatus3 = new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
                        return itemStatus3;
                    }
                    Stopwatch extractSeda = Stopwatch.createStarted();
                    ItemStatus extractSedaStatus = extractSedaActionHandler.execute(params, handlerIO);
                    PerformanceLogger.getInstance().log("STP_INGEST_CONTROL_SIP", HANDLER_ID, "extractSeda", extractSeda.elapsed(TimeUnit.MILLISECONDS));
                    itemStatus.setItemsStatus(ExtractSedaActionHandler.getId(), extractSedaStatus);
                    if (extractSedaStatus.shallStop(true)) {
                        this.resetItemStatusMeter(itemStatus);
                        ItemStatus itemStatus4 = new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
                        return itemStatus4;
                    }
                    handlerIO.getInput().clear();
                    ArrayList<IOParameter> inputList = new ArrayList<IOParameter>();
                    inputList.add(new IOParameter().setUri(handlerIO.getOutput(4)));
                    inputList.add(new IOParameter().setUri(handlerIO.getOutput(8)));
                    handlerIO.addInIOParameters(inputList);
                    handlerIO.getOutput().clear();
                    Stopwatch checkObjectUnitConsistency = Stopwatch.createStarted();
                    ItemStatus checkObjectUnitConsistencyStatus = checkObjectUnitConsistencyActionHandler.execute(params, handlerIO);
                    PerformanceLogger.getInstance().log("STP_INGEST_CONTROL_SIP", HANDLER_ID, "checkObjectUnitConsistency", checkObjectUnitConsistency.elapsed(TimeUnit.MILLISECONDS));
                    itemStatus.setItemsStatus(CheckObjectUnitConsistencyActionHandler.getId(), checkObjectUnitConsistencyStatus);
                }
            }
            catch (ProcessingException e) {
                LOGGER.error((Throwable)e);
                itemStatus.increment(StatusCode.FATAL);
            }
        }
        this.resetItemStatusMeter(itemStatus);
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    private void resetItemStatusMeter(ItemStatus itemStatus) {
        itemStatus.reinitStatusMeter();
        itemStatus.setStatusMeterValue(itemStatus.getGlobalStatus(), Integer.valueOf(1));
    }
}

