/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.LightweightWorkflowLock;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CheckConcurrentWorkflowLockHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckConcurrentWorkflowLockHandler.class);
    private static final String CHECK_CONCURRENT_WORKFLOW_LOCK = "CHECK_CONCURRENT_WORKFLOW_LOCK";
    private static final int WORKFLOW_IDS_RANK = 0;
    static final String CONCURRENT_PROCESSES_FOUND = "Concurrent process(es) found";
    private final LightweightWorkflowLock lightweightWorkflowLock;

    public CheckConcurrentWorkflowLockHandler() {
        this(new LightweightWorkflowLock());
    }

    @VisibleForTesting
    CheckConcurrentWorkflowLockHandler(LightweightWorkflowLock lightweightWorkflowLock) {
        this.lightweightWorkflowLock = lightweightWorkflowLock;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            String workflowIdsStr = (String)handler.getInput(0);
            List<String> workflowIds = Arrays.stream(workflowIdsStr.split(",")).map(String::trim).collect(Collectors.toList());
            List<ProcessDetail> concurrentWorkflows = this.lightweightWorkflowLock.listConcurrentWorkflows(workflowIds, param.getContainerName());
            if (!concurrentWorkflows.isEmpty()) {
                LOGGER.error("Concurrent process(es) found " + concurrentWorkflows.stream().map(i -> i.getProcessType() + " " + i.getOperationId() + "(" + i.getGlobalState() + "/" + i.getStepStatus() + ")").collect(Collectors.joining(", ", "[", "]")));
                ObjectNode eventDetails = JsonHandler.createObjectNode();
                eventDetails.put("error", CONCURRENT_PROCESSES_FOUND);
                return PluginHelper.buildItemStatus(CHECK_CONCURRENT_WORKFLOW_LOCK, StatusCode.KO, eventDetails);
            }
        }
        catch (VitamClientException e) {
            LOGGER.error("Concurrent workflow lock check failed", (Throwable)e);
            return PluginHelper.buildItemStatus(CHECK_CONCURRENT_WORKFLOW_LOCK, StatusCode.FATAL, null);
        }
        LOGGER.info("Concurrent workflow lock check succeeded");
        return PluginHelper.buildItemStatus(CHECK_CONCURRENT_WORKFLOW_LOCK, StatusCode.OK, null);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return CHECK_CONCURRENT_WORKFLOW_LOCK;
    }
}

