/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitam.common.model.administration.ProfileStatus;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.List;

public class CheckArchiveProfileRelationActionHandler
extends ActionHandler {
    private static final String UNKNOWN_TECHNICAL_EXCEPTION = "Unknown technical exception";
    private static final String CAN_NOT_GET_THE_INGEST_CONTRACT = "Can_not_get_the_ingest_contract";
    private static final String CAN_NOT_GET_THE_PROFILE = "Can_not_get_the_profile";
    private static final String THE_PROFILE_NOT_FOUND = "Profile_Not_Found";
    private static final String PROFILE_NOT_FOUND = "Profile not found";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckArchiveProfileRelationActionHandler.class);
    private static final String HANDLER_ID = "CHECK_IC_AP_RELATION";
    private static final int PROFILE_IDENTIFIER_RANK = 0;
    private static final int CONTRACT_IDENTIFIER_RANK = 1;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public CheckArchiveProfileRelationActionHandler() {
        this(AdminManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    public CheckArchiveProfileRelationActionHandler(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        String profileIdentifier = (String)handlerIO.getInput(0);
        String ingestContractIdentifier = (String)handlerIO.getInput(1);
        CheckProfileStatus status = null;
        ObjectNode infoNode = JsonHandler.createObjectNode();
        String dataKey = null;
        String dataValue = null;
        try (AdminManagementClient adminClient = this.adminManagementClientFactory.getClient();){
            Select select;
            if (ParametersChecker.isNotEmpty((String[])new String[]{profileIdentifier})) {
                select = new Select();
                select.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)profileIdentifier));
                RequestResponse response = adminClient.findProfiles((JsonNode)select.getFinalSelect());
                if (response.isOk()) {
                    List results = ((RequestResponseOK)response).getResults();
                    if (null != results && results.size() > 0) {
                        ProfileModel profile = (ProfileModel)results.iterator().next();
                        if (!ProfileStatus.ACTIVE.equals((Object)profile.getStatus())) {
                            status = CheckProfileStatus.INACTIVE;
                        }
                    } else {
                        dataKey = THE_PROFILE_NOT_FOUND;
                        dataValue = profileIdentifier;
                        status = CheckProfileStatus.UNKNOWN;
                    }
                } else {
                    dataKey = CAN_NOT_GET_THE_PROFILE;
                    dataValue = profileIdentifier;
                    status = CheckProfileStatus.UNKNOWN;
                }
            } else {
                profileIdentifier = null;
            }
            if (null == status) {
                if (ParametersChecker.isNotEmpty((String[])new String[]{ingestContractIdentifier})) {
                    select = new Select();
                    select.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)ingestContractIdentifier));
                    ObjectNode queryDsl = select.getFinalSelect();
                    RequestResponse referenceContracts = adminClient.findIngestContracts((JsonNode)queryDsl);
                    if (referenceContracts.isOk()) {
                        List results = ((RequestResponseOK)referenceContracts).getResults();
                        if (null != results && results.size() > 0) {
                            IngestContractModel contract = (IngestContractModel)results.iterator().next();
                            status = null == profileIdentifier && contract.getArchiveProfiles().isEmpty() || contract.getArchiveProfiles().contains(profileIdentifier) ? CheckProfileStatus.OK : CheckProfileStatus.DIFF;
                        } else {
                            dataKey = CAN_NOT_GET_THE_INGEST_CONTRACT;
                            dataValue = ingestContractIdentifier;
                            status = CheckProfileStatus.UNKNOWN;
                        }
                    } else {
                        dataKey = CAN_NOT_GET_THE_INGEST_CONTRACT;
                        dataValue = ingestContractIdentifier;
                        status = CheckProfileStatus.UNKNOWN;
                    }
                } else {
                    status = CheckProfileStatus.OK;
                }
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientServerException e) {
            LOGGER.error(PROFILE_NOT_FOUND, e);
            status = CheckProfileStatus.KO;
        }
        catch (Exception e) {
            LOGGER.error(UNKNOWN_TECHNICAL_EXCEPTION, (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        }
        switch (status) {
            case INACTIVE: {
                itemStatus.setGlobalOutcomeDetailSubcode(CheckProfileStatus.INACTIVE.toString());
                infoNode.put("evDetTechData", "The profile " + profileIdentifier + " has not the status ACTIVE");
                itemStatus.increment(StatusCode.KO);
                break;
            }
            case UNKNOWN: {
                itemStatus.setGlobalOutcomeDetailSubcode(CheckProfileStatus.UNKNOWN.toString());
                itemStatus.increment(StatusCode.KO);
                infoNode.put("evDetTechData", dataKey + " " + dataValue);
                break;
            }
            case DIFF: {
                itemStatus.setGlobalOutcomeDetailSubcode(CheckProfileStatus.DIFF.toString());
                itemStatus.increment(StatusCode.KO);
                infoNode.put("evDetTechData", "The profile " + profileIdentifier + " was not found in the ingest contract");
                break;
            }
            case KO: {
                itemStatus.increment(StatusCode.KO);
                break;
            }
            case OK: {
                itemStatus.increment(StatusCode.OK);
            }
        }
        infoNode.put("ArchivalProfile", profileIdentifier);
        String evdev = JsonHandler.unprettyPrint((Object)infoNode);
        itemStatus.setEvDetailData(evdev);
        itemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)evdev);
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static enum CheckProfileStatus {
        UNKNOWN,
        INACTIVE,
        DIFF,
        OK,
        KO;

    }
}

