/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ProfileFormat;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.xml.RngValidator;
import fr.gouv.vitam.common.xml.XsdValidator;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.ProfileNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ProfilePathFileNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class CheckArchiveProfileActionHandler
extends ActionHandler {
    private static final String NOT_FOUND = " not found";
    private static final String UNKNOWN_TECHNICAL_EXCEPTION = "Unknown technical exception";
    private static final String VALIDATION_ERROR = "ValidationError";
    private static final String CAN_NOT_SEARCH_PROFILE = "Can not search profile";
    private static final String PROFILE_NOT_FOUND = "Profile not found";
    private static final String PROFILE_PATH_NOT_FOUND = "There is no Profile path file for";
    private static final String CAN_NOT_GET_FILE_MANIFEST = "Can not get file manifest";
    private static final String FILE_NOT_FOUND = "File not found";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckArchiveProfileActionHandler.class);
    private static final String HANDLER_ID = "CHECK_ARCHIVEPROFILE";
    private static final int PROFILE_IDENTIFIER_RANK = 0;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public CheckArchiveProfileActionHandler() {
        this(AdminManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    public CheckArchiveProfileActionHandler(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        Boolean isValid;
        ObjectNode infoNode;
        String profileIdentifier;
        ItemStatus itemStatus;
        block20: {
            this.checkMandatoryParameters(params);
            itemStatus = new ItemStatus(HANDLER_ID);
            profileIdentifier = (String)handlerIO.getInput(0);
            infoNode = JsonHandler.createObjectNode();
            isValid = true;
            try (AdminManagementClient adminClient = this.adminManagementClientFactory.getClient();){
                block21: {
                    XsdValidator validator;
                    File schemaFile;
                    Select select = new Select();
                    select.setQuery((Query)QueryHelper.eq((String)"Identifier", (String)profileIdentifier));
                    RequestResponse response = adminClient.findProfiles((JsonNode)select.getFinalSelect());
                    ProfileModel profile = null;
                    if (response.isOk() && ((RequestResponseOK)response).getResults().size() > 0) {
                        profile = (ProfileModel)((RequestResponseOK)response).getResults().get(0);
                    }
                    if (profile == null) break block21;
                    this.checkProfilePath(profile);
                    Response downloadResponse = null;
                    InputStream stream = null;
                    try {
                        downloadResponse = adminClient.downloadProfileFile(profileIdentifier);
                        stream = (InputStream)downloadResponse.readEntity(InputStream.class);
                        schemaFile = PropertiesUtils.fileFromTmpFolder((String)profile.getPath());
                        FileOutputStream outputStream = new FileOutputStream(schemaFile);
                        IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable throwable) {
                        StreamUtils.closeSilently(stream);
                        StreamUtils.consumeAnyEntityAndClose((Response)downloadResponse);
                        throw throwable;
                    }
                    StreamUtils.closeSilently((InputStream)stream);
                    StreamUtils.consumeAnyEntityAndClose((Response)downloadResponse);
                    if (profile.getFormat().equals((Object)ProfileFormat.XSD)) {
                        validator = new XsdValidator(schemaFile);
                        validator.validate(handlerIO.getFileFromWorkspace("SIP/manifest.xml"));
                        isValid = true;
                    }
                    if (profile.getFormat().equals((Object)ProfileFormat.RNG)) {
                        validator = new RngValidator(schemaFile);
                        validator.validate(handlerIO.getFileFromWorkspace("SIP/manifest.xml"));
                        isValid = true;
                    }
                    break block20;
                }
                throw new ProfileNotFoundException(profileIdentifier + NOT_FOUND);
            }
            catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                LOGGER.error(CAN_NOT_SEARCH_PROFILE, e);
                return this.getItemStatus(itemStatus, "evDetTechData", "Can not search profile " + profileIdentifier, infoNode, StatusCode.KO);
            }
            catch (ProfileNotFoundException e) {
                LOGGER.error(PROFILE_NOT_FOUND, (Throwable)e);
                return this.getItemStatus(itemStatus, "evDetTechData", "Profile not found " + profileIdentifier, infoNode, StatusCode.KO);
            }
            catch (ProfilePathFileNotFoundException e) {
                LOGGER.error(PROFILE_PATH_NOT_FOUND, (Throwable)e);
                return this.getItemStatus(itemStatus, "evDetTechData", "There is no Profile path file for " + profileIdentifier, infoNode, StatusCode.KO);
            }
            catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
                LOGGER.error(CAN_NOT_GET_FILE_MANIFEST, e);
                return this.getItemStatus(itemStatus, "evDetTechData", "Can not get file manifest manifest.xml", infoNode, StatusCode.FATAL);
            }
            catch (IOException e) {
                LOGGER.error(FILE_NOT_FOUND, (Throwable)e);
                return this.getItemStatus(itemStatus, "evDetTechData", "File not found " + profileIdentifier, infoNode, StatusCode.KO);
            }
            catch (SAXException e) {
                LOGGER.error(VALIDATION_ERROR, (Throwable)e);
                infoNode.put("evDetTechData", e.getMessage());
                String evdev = JsonHandler.unprettyPrint((Object)infoNode);
                itemStatus.setEvDetailData(evdev);
                itemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)evdev);
                isValid = false;
            }
            catch (Exception e) {
                LOGGER.error(UNKNOWN_TECHNICAL_EXCEPTION, (Throwable)e);
                itemStatus.increment(StatusCode.FATAL);
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
        }
        if (isValid.booleanValue()) {
            return this.getItemStatus(itemStatus, "ArchivalProfile", profileIdentifier, infoNode, StatusCode.OK);
        }
        return this.getItemStatus(itemStatus, "ArchivalProfile", profileIdentifier, infoNode, StatusCode.KO);
    }

    private ItemStatus getItemStatus(ItemStatus itemStatus, String logbookField, String evTechDataMessage, ObjectNode infoNode, StatusCode statusCode) {
        itemStatus.increment(statusCode);
        infoNode.put(logbookField, evTechDataMessage);
        String evdev = JsonHandler.unprettyPrint((Object)infoNode);
        itemStatus.setEvDetailData(evdev);
        itemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)evdev);
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private void checkProfilePath(ProfileModel profile) throws ProfilePathFileNotFoundException {
        if (StringUtils.isBlank((CharSequence)profile.getPath())) {
            throw new ProfilePathFileNotFoundException("The profile path for (XSD or RNG) file not Found");
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

