/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterStatus;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitam.common.model.administration.RegisterValueEventModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.metadata.api.model.ObjectGroupPerOriginatingAgency;
import fr.gouv.vitam.metadata.api.model.UnitPerOriginatingAgency;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractAccessionRegisterAction
extends ActionHandler
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AbstractAccessionRegisterAction.class);
    private static final String VOLUMETRY = "Volumetry";
    private final MetaDataClientFactory metaDataClientFactory;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public AbstractAccessionRegisterAction() {
        this(MetaDataClientFactory.getInstance(), AdminManagementClientFactory.getInstance());
    }

    public AbstractAccessionRegisterAction(MetaDataClientFactory metaDataClientFactory, AdminManagementClientFactory adminManagementClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(this.getHandlerId());
        int tenantId = ParameterHelper.getTenantParameter();
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();
             MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            AccessionRegisterInfo accessionRegisterInfo = new AccessionRegisterInfo();
            if (LogbookTypeProcess.INGEST.equals((Object)this.getOperationType())) {
                this.prepareAccessionRegisterInformation(params, handler, accessionRegisterInfo);
            }
            String operationId = params.getContainerName();
            List objectGroupPerOriginatingAgencies = metaDataClient.selectAccessionRegisterOnObjectByOperationId(operationId);
            HashMap<Object, Map> byOperationMap = new HashMap<Object, Map>();
            if (objectGroupPerOriginatingAgencies == null || objectGroupPerOriginatingAgencies.isEmpty()) {
                byOperationMap.put(operationId, new HashMap());
            } else {
                for (ObjectGroupPerOriginatingAgency o : objectGroupPerOriginatingAgencies) {
                    ObjectGroupPerOriginatingAgency ino;
                    String qualifierVersionOpi = o.getOperation();
                    String agency = o.getAgency();
                    Map byAgencyMap = byOperationMap.getOrDefault(qualifierVersionOpi, new HashMap());
                    if (byAgencyMap.isEmpty()) {
                        byOperationMap.put(qualifierVersionOpi, byAgencyMap);
                    }
                    if (null == (ino = (ObjectGroupPerOriginatingAgency)byAgencyMap.get(agency))) {
                        byAgencyMap.put(agency, o);
                        continue;
                    }
                    ino.setNumberOfGOT(ino.getNumberOfGOT() + o.getNumberOfGOT());
                    ino.setNumberOfObject(ino.getNumberOfObject() + o.getNumberOfObject());
                    ino.setSize(ino.getSize() + o.getSize());
                }
            }
            if (byOperationMap.keySet().size() > 1) {
                LOGGER.warn("Compute AccessionRegister :  Multiple operations found [" + byOperationMap.keySet() + "]. Only current operation [" + operationId + "] should be returned ");
            }
            ArrayList unitPerOriginatingAgencies = null;
            if (LogbookTypeProcess.INGEST.equals((Object)this.getOperationType())) {
                unitPerOriginatingAgencies = metaDataClient.selectAccessionRegisterOnUnitByOperationId(operationId);
            }
            if (unitPerOriginatingAgencies == null) {
                unitPerOriginatingAgencies = new ArrayList();
            }
            HashMap<String, UnitPerOriginatingAgency> unitPerOriginatingAgenciesMap = new HashMap<String, UnitPerOriginatingAgency>();
            for (UnitPerOriginatingAgency o : unitPerOriginatingAgencies) {
                unitPerOriginatingAgenciesMap.put(o.getValue(), o);
            }
            Map objectGroupPerOriginatingAgenciesMap = byOperationMap.getOrDefault(operationId, new HashMap());
            if (unitPerOriginatingAgenciesMap.isEmpty() && objectGroupPerOriginatingAgenciesMap.isEmpty()) {
                UnitPerOriginatingAgency o;
                o = itemStatus.increment(StatusCode.OK);
                return o;
            }
            Set agencies = Stream.concat(unitPerOriginatingAgenciesMap.keySet().stream(), objectGroupPerOriginatingAgenciesMap.keySet().stream()).collect(Collectors.toSet());
            for (String agency : agencies) {
                if (LogbookTypeProcess.INGEST.equals((Object)this.getOperationType()) && !agency.equals(accessionRegisterInfo.getOriginatingAgency())) continue;
                AccessionRegisterDetailModel register = this.generateAccessionRegister(params, operationId, operationId, objectGroupPerOriginatingAgenciesMap.getOrDefault(agency, new ObjectGroupPerOriginatingAgency().setAgency(agency)), unitPerOriginatingAgenciesMap.getOrDefault(agency, new UnitPerOriginatingAgency(agency, 0L)), accessionRegisterInfo, tenantId);
                if (null == register) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("All count equals to 0 => register not created for Originating Agency: " + agency);
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("register ID / Originating Agency: " + register.getId() + " / " + register.getOriginatingAgency());
                }
                ObjectNode evDetDataInformation = JsonHandler.createObjectNode();
                ArrayNode arrayInformation = JsonHandler.createArrayNode();
                ObjectNode jsonNodeRegister = (ObjectNode)JsonHandler.toJsonNode((Object)register);
                jsonNodeRegister.put("_id", register.getId());
                jsonNodeRegister.put("_tenant", tenantId);
                jsonNodeRegister.put("_v", 0);
                jsonNodeRegister.remove("#id");
                arrayInformation.addPOJO((Object)jsonNodeRegister);
                adminManagementClient.createOrUpdateAccessionRegister(register);
                if (arrayInformation.size() <= 0) continue;
                evDetDataInformation.set(VOLUMETRY, (JsonNode)arrayInformation);
                itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)evDetDataInformation));
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (Exception e) {
            LOGGER.error("unable to call metadata Client", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        LOGGER.debug("TransferNotificationActionHandler response: " + itemStatus.getGlobalStatus());
        return new ItemStatus(this.getHandlerId()).setItemsStatus(this.getHandlerId(), itemStatus);
    }

    protected abstract String getHandlerId();

    protected abstract void prepareAccessionRegisterInformation(WorkerParameters var1, HandlerIO var2, AccessionRegisterInfo var3) throws ProcessingException, InvalidParseOperationException;

    protected abstract LogbookTypeProcess getOperationType();

    private AccessionRegisterDetailModel generateAccessionRegister(WorkerParameters params, String ingestOperation, String currentOperation, ObjectGroupPerOriginatingAgency objectGroupPerOriginatingAgency, UnitPerOriginatingAgency unitPerOriginatingAgency, AccessionRegisterInfo accessionRegisterInfo, int tenantId) {
        boolean zeroUnit;
        String unitAgency = unitPerOriginatingAgency.getValue();
        long unitCount = unitPerOriginatingAgency.getCount();
        long nbGot = objectGroupPerOriginatingAgency.getNumberOfGOT();
        long nbObject = objectGroupPerOriginatingAgency.getNumberOfObject();
        long size = objectGroupPerOriginatingAgency.getSize();
        boolean returnNull = 0L == nbGot && 0L == nbObject && 0L == size;
        boolean bl = zeroUnit = unitCount == 0L;
        if (zeroUnit && returnNull) {
            return null;
        }
        RegisterValueDetailModel totalUnits = new RegisterValueDetailModel().setIngested(unitCount).setRemained(unitCount);
        RegisterValueDetailModel totalObjectsGroups = new RegisterValueDetailModel().setIngested(nbGot).setRemained(nbGot);
        RegisterValueDetailModel totalObjects = new RegisterValueDetailModel().setIngested(nbObject).setRemained(nbObject);
        RegisterValueDetailModel objectSize = new RegisterValueDetailModel().setIngested(size).setRemained(size);
        String updateDate = LocalDateUtil.nowFormatted();
        GUID guid = GUIDFactory.newAccessionRegisterDetailGUID((int)tenantId);
        RegisterValueEventModel registerValueEvent = new RegisterValueEventModel().setOperation(currentOperation).setOperationType(this.getOperationType().name()).setTotalUnits(totalUnits.getRemained()).setTotalGots(totalObjectsGroups.getRemained()).setTotalObjects(totalObjects.getRemained()).setObjectSize(objectSize.getRemained()).setCreationdate(LocalDateUtil.nowFormatted());
        return new AccessionRegisterDetailModel().setId(guid.toString()).setOpc(currentOperation).setOriginatingAgency(unitAgency).setSubmissionAgency(accessionRegisterInfo.getSubmissionAgency()).setArchivalAgreement(accessionRegisterInfo.getArchivalAgreement()).setAcquisitionInformation(accessionRegisterInfo.getAcquisitionInformation()).setLegalStatus(accessionRegisterInfo.getLegalStatus()).setArchivalProfile(accessionRegisterInfo.getArchivalProfile()).setObIdIn(accessionRegisterInfo.getMessageIdentifier()).setComment(accessionRegisterInfo.getComment()).setEndDate(updateDate).setLastUpdate(updateDate).setStartDate(updateDate).setStatus(AccessionRegisterStatus.STORED_AND_COMPLETED).setTotalObjectsGroups(totalObjectsGroups).setTotalUnits(totalUnits).setTotalObjects(totalObjects).setObjectSize(objectSize).setOpi(ingestOperation).setOperationType(this.getOperationType().name()).addEvent(registerValueEvent).addOperationsId(params.getContainerName()).setTenant(Integer.valueOf(tenantId));
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        if (LogbookTypeProcess.INGEST.equals((Object)this.getOperationType()) && !handler.checkHandlerIO(0, (List)Lists.newArrayList((Object[])new Class[]{File.class}))) {
            throw new ProcessingException("Input/Output io parameter is not correct");
        }
    }

    public void close() {
    }

    protected static class AccessionRegisterInfo {
        String originatingAgency;
        String submissionAgency = null;
        String acquisitionInformation = null;
        String legalStatus = null;
        String archivalAgreement = null;
        String archivalProfile = null;
        String messageIdentifier = null;
        List<String> comment;

        protected AccessionRegisterInfo() {
        }

        public String getOriginatingAgency() {
            return this.originatingAgency;
        }

        public void setOriginatingAgency(String originatingAgency) {
            this.originatingAgency = originatingAgency;
        }

        public String getSubmissionAgency() {
            if (Strings.isNullOrEmpty((String)this.submissionAgency)) {
                this.submissionAgency = this.originatingAgency;
            }
            return this.submissionAgency;
        }

        public void setSubmissionAgency(String submissionAgency) {
            this.submissionAgency = submissionAgency;
        }

        public String getAcquisitionInformation() {
            return this.acquisitionInformation;
        }

        public void setAcquisitionInformation(String acquisitionInformation) {
            this.acquisitionInformation = acquisitionInformation;
        }

        public String getLegalStatus() {
            return this.legalStatus;
        }

        public void setLegalStatus(String legalStatus) {
            this.legalStatus = legalStatus;
        }

        public String getArchivalAgreement() {
            return this.archivalAgreement;
        }

        public void setArchivalAgreement(String archivalAgreement) {
            this.archivalAgreement = archivalAgreement;
        }

        public String getArchivalProfile() {
            return this.archivalProfile;
        }

        public void setArchivalProfile(String archivalProfile) {
            this.archivalProfile = archivalProfile;
        }

        public String getMessageIdentifier() {
            return this.messageIdentifier;
        }

        public void setMessageIdentifier(String messageIdentifier) {
            this.messageIdentifier = messageIdentifier;
        }

        public List<String> getComment() {
            return this.comment;
        }

        public void setComment(List<String> comment) {
            this.comment = comment;
        }
    }
}

