/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.extractseda;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2.BinaryDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectGroupType;
import fr.gouv.culture.archivesdefrance.seda.v2.MinimalDataObjectType;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.DbVersionsModel;
import fr.gouv.vitam.common.model.unit.GotObj;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingMalformedDataException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectReferenceException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.DataObjectDetail;
import fr.gouv.vitam.worker.common.utils.DataObjectInfo;
import fr.gouv.vitam.worker.core.extractseda.ArchiveUnitListener;
import fr.gouv.vitam.worker.core.extractseda.IngestContext;
import fr.gouv.vitam.worker.core.extractseda.IngestSession;
import fr.gouv.vitam.worker.core.handler.LogbookEventMapper;
import fr.gouv.vitam.worker.core.mapping.ObjectGroupMapper;
import fr.gouv.vitam.worker.core.utils.JsonLineDataBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

public class ExtractMetadataListener
extends Unmarshaller.Listener {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ExtractMetadataListener.class);
    private final ArchiveUnitListener archiveUnitListener;
    private final HandlerIO handlerIO;
    private final IngestSession ingestSession;
    private final JsonLineDataBase objectsDatabase;

    public ExtractMetadataListener(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, JsonLineDataBase unitsDatabase, JsonLineDataBase objectsDatabase, MetaDataClientFactory metaDataClientFactory) {
        this.archiveUnitListener = new ArchiveUnitListener(handlerIO, ingestContext, ingestSession, unitsDatabase, metaDataClientFactory);
        this.handlerIO = handlerIO;
        this.ingestSession = ingestSession;
        this.objectsDatabase = objectsDatabase;
    }

    public void afterUnmarshal(Object target, Object parent) {
        if (target instanceof ArchiveUnitType) {
            this.archiveUnitListener.extractArchiveUnit((ArchiveUnitType)target, (JAXBElement)parent);
        } else if (target instanceof DataObjectGroupType) {
            String objectGroupGuid;
            DataObjectGroupType objectGroupType = (DataObjectGroupType)target;
            String currentGroupId = objectGroupType.getId();
            if (this.ingestSession.getObjectGroupIdToGuid().get(currentGroupId) == null) {
                objectGroupGuid = GUIDFactory.newObjectGroupGUID((int)ParameterHelper.getTenantParameter()).toString();
                this.ingestSession.getObjectGroupIdToGuid().put(currentGroupId, objectGroupGuid);
            }
            objectGroupGuid = this.ingestSession.getObjectGroupIdToGuid().get(currentGroupId);
            if (objectGroupType.getLogBook() != null) {
                this.extractLogbook(objectGroupType, objectGroupGuid);
            }
        } else if (target instanceof MinimalDataObjectType) {
            MinimalDataObjectType dataObject = (MinimalDataObjectType)target;
            String currentGroupId = parent instanceof DataObjectGroupType ? ((DataObjectGroupType)parent).getId() : dataObject.getDataObjectGroupId();
            if (currentGroupId == null) {
                currentGroupId = dataObject.getDataObjectGroupReferenceId();
            }
            if (currentGroupId == null) {
                LOGGER.warn("Current object does not have an ObjectGroup ! auto creating ObjectGroup using the same ID of Object");
                currentGroupId = dataObject.getId();
            }
            String objectGroupGuid = Objects.requireNonNullElse(this.ingestSession.getObjectGroupIdToGuid().get(currentGroupId), GUIDFactory.newObjectGroupGUID((int)ParameterHelper.getTenantParameter()).toString());
            this.extractDataObject(currentGroupId, objectGroupGuid, dataObject);
            this.updateState(currentGroupId, dataObject);
        }
        super.afterUnmarshal(target, parent);
    }

    private void extractLogbook(DataObjectGroupType objectGroupType, String objectGroupGuid) {
        List logbookEvents = objectGroupType.getLogBook().getEvent().stream().map(LogbookEventMapper::map).collect(Collectors.toList());
        File logbookTmpFile = this.handlerIO.getNewLocalFile(objectGroupGuid + "_logbook_OG.json");
        try {
            JsonHandler.writeAsFile(logbookEvents, (File)logbookTmpFile);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private void extractDataObject(String currentGroupId, String objectGroupGuid, MinimalDataObjectType dataObject) {
        try {
            String objectGuid = GUIDFactory.newObjectGUID((int)ParameterHelper.getTenantParameter()).toString();
            DbVersionsModel versionsModel = ObjectGroupMapper.map(dataObject, objectGroupGuid);
            JsonNode value = (JsonNode)VitamObjectMapper.getSerializationObjectMapper().convertValue((Object)versionsModel, JsonNode.class);
            this.objectsDatabase.write(objectGuid, value);
            DataObjectDetail detail = new DataObjectDetail();
            if (dataObject instanceof BinaryDataObjectType) {
                DataObjectInfo dataObjectInfo = new DataObjectInfo();
                dataObjectInfo.setId(objectGuid);
                dataObjectInfo.setSize(Long.valueOf(versionsModel.getSize()));
                dataObjectInfo.setUri(versionsModel.getUri());
                dataObjectInfo.setAlgo(DigestType.fromValue((String)versionsModel.getAlgorithm()));
                dataObjectInfo.setMessageDigest(versionsModel.getMessageDigest());
                long gotSize = this.checkAndComputeSize(versionsModel, dataObjectInfo);
                dataObjectInfo.setSize(Long.valueOf(gotSize));
                detail.setVersion(Objects.requireNonNullElse(dataObject.getDataObjectVersion(), DataObjectVersionType.BINARY_MASTER.getName()));
                detail.setPhysical(false);
                this.ingestSession.getObjectGuidToDataObject().put(objectGuid, dataObjectInfo);
                if (dataObject.getDataObjectVersion() == null || dataObject.getDataObjectVersion().startsWith(DataObjectVersionType.BINARY_MASTER.getName())) {
                    this.ingestSession.getDataObjectGroupMasterMandatory().put(currentGroupId, true);
                } else {
                    this.ingestSession.getDataObjectGroupMasterMandatory().putIfAbsent(currentGroupId, false);
                }
            } else {
                detail.setVersion(Objects.requireNonNullElse(dataObject.getDataObjectVersion(), DataObjectVersionType.PHYSICAL_MASTER.getName()));
                detail.setPhysical(true);
                this.ingestSession.getPhysicalDataObjetsGuids().add(objectGuid);
                this.ingestSession.getDataObjectGroupMasterMandatory().put(currentGroupId, true);
            }
            this.ingestSession.getDataObjectIdToDetailDataObject().put(dataObject.getId(), detail);
            this.ingestSession.getDataObjectIdToObjectGroupId().put(versionsModel.getId(), currentGroupId);
            this.ingestSession.getDataObjectIdToGuid().put(versionsModel.getId(), objectGuid);
            this.ingestSession.getObjectGroupIdToGuid().put(currentGroupId, objectGroupGuid);
            this.ingestSession.getUsageToObjectGroupId().put((Object)dataObject.getDataObjectVersion(), (Object)objectGroupGuid);
            if (currentGroupId.equals(dataObject.getId()) && this.ingestSession.getDataObjectIdWithoutObjectGroupId().get(dataObject.getId()) == null) {
                GotObj gotObj = new GotObj(currentGroupId, false);
                this.ingestSession.getDataObjectIdWithoutObjectGroupId().put(versionsModel.getId(), gotObj);
            }
        }
        catch (ProcessingMalformedDataException | ProcessingObjectReferenceException e) {
            throw new VitamRuntimeException(e);
        }
    }

    private long checkAndComputeSize(DbVersionsModel versionsModel, DataObjectInfo dataObjectInfo) {
        ObjectNode diffJsonNodeToPopulate = JsonHandler.createObjectNode();
        long binarySizeInManifest = versionsModel.getSize();
        long binarySizeInWorkspace = this.ingestSession.getFileWithParmsFromFolder().get(dataObjectInfo.getUri());
        if (binarySizeInManifest == 0L) {
            diffJsonNodeToPopulate.put("- Size", "");
            diffJsonNodeToPopulate.put("+ Size", binarySizeInWorkspace);
            dataObjectInfo.setDiffSizeJson(diffJsonNodeToPopulate);
            dataObjectInfo.setSizeIncorrect(Boolean.FALSE);
        } else if (binarySizeInWorkspace != binarySizeInManifest) {
            diffJsonNodeToPopulate.put("- Size", binarySizeInManifest);
            diffJsonNodeToPopulate.put("+ Size", binarySizeInWorkspace);
            dataObjectInfo.setDiffSizeJson(diffJsonNodeToPopulate);
            dataObjectInfo.setSizeIncorrect(Boolean.TRUE);
        }
        return binarySizeInWorkspace;
    }

    private void updateState(String currentGroupId, MinimalDataObjectType dataObject) {
        if (this.ingestSession.getObjectGroupIdToDataObjectId().get(currentGroupId) == null) {
            ArrayList<String> dataOjectList = new ArrayList<String>();
            dataOjectList.add(dataObject.getId());
            this.ingestSession.getObjectGroupIdToDataObjectId().put(currentGroupId, dataOjectList);
        } else {
            this.ingestSession.getObjectGroupIdToDataObjectId().get(currentGroupId).add(dataObject.getId());
        }
    }
}

