/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.extractseda;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitIdentifierKeyType;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2.CustodialHistoryType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectOrArchiveUnitReferenceType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectRefType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveMetadataContentType;
import fr.gouv.culture.archivesdefrance.seda.v2.ObjectGroupRefType;
import fr.gouv.culture.archivesdefrance.seda.v2.RelatedObjectReferenceType;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.IngestContractCheckState;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicyTypeEnum;
import fr.gouv.vitam.common.model.unit.ArchiveUnitRoot;
import fr.gouv.vitam.common.model.unit.DataObjectReference;
import fr.gouv.vitam.common.model.unit.DescriptiveMetadataModel;
import fr.gouv.vitam.common.model.unit.GotObj;
import fr.gouv.vitam.common.model.unit.RuleCategoryModel;
import fr.gouv.vitam.common.model.unit.RuleModel;
import fr.gouv.vitam.common.model.unit.SignatureTypeModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ExceptionType;
import fr.gouv.vitam.processing.common.exception.ProcessingAttachmentUnauthorizedException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.exception.ProcessingMalformedDataException;
import fr.gouv.vitam.processing.common.exception.ProcessingManifestReferenceException;
import fr.gouv.vitam.processing.common.exception.ProcessingNotFoundException;
import fr.gouv.vitam.processing.common.exception.ProcessingNotValidLinkingException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectGroupLinkingException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectReferenceException;
import fr.gouv.vitam.processing.common.exception.ProcessingTooManyUnitsFoundException;
import fr.gouv.vitam.processing.common.exception.ProcessingUnitLinkingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.extractseda.IngestContext;
import fr.gouv.vitam.worker.core.extractseda.IngestSession;
import fr.gouv.vitam.worker.core.handler.PersistentIdentifierGenerationService;
import fr.gouv.vitam.worker.core.mapping.ArchiveUnitMapper;
import fr.gouv.vitam.worker.core.mapping.DescriptiveMetadataMapper;
import fr.gouv.vitam.worker.core.mapping.RuleMapper;
import fr.gouv.vitam.worker.core.utils.JsonLineDataBase;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBElement;

public class ArchiveUnitListener {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ArchiveUnitListener.class);
    private static final String LFC_INITIAL_CREATION_EVENT_TYPE = "LFC_CREATION";
    private final ArchiveUnitMapper archiveUnitMapper;
    private final IngestContext ingestContext;
    private final IngestSession ingestSession;
    private final HandlerIO handlerIO;
    private final JsonLineDataBase unitsDatabase;
    private boolean attachByIngestContractChecked = false;
    private final MetaDataClientFactory metaDataClientFactory;
    private final PersistentIdentifierGenerationService persistentIdentifierGenerationService;

    public ArchiveUnitListener(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, JsonLineDataBase unitsDatabase, MetaDataClientFactory metaDataClientFactory) {
        this.handlerIO = handlerIO;
        this.ingestContext = ingestContext;
        this.ingestSession = ingestSession;
        this.unitsDatabase = unitsDatabase;
        DescriptiveMetadataMapper descriptiveMetadataMapper = new DescriptiveMetadataMapper();
        RuleMapper ruleMapper = new RuleMapper();
        this.archiveUnitMapper = new ArchiveUnitMapper(descriptiveMetadataMapper, ruleMapper);
        this.metaDataClientFactory = metaDataClientFactory;
        this.persistentIdentifierGenerationService = PersistentIdentifierGenerationService.getInstance();
    }

    public void extractArchiveUnit(@Nonnull ArchiveUnitType archiveUnitType, @Nonnull JAXBElement<?> jaxbElementParent) {
        ArchiveUnitRoot archiveUnitRoot;
        boolean isValidAttachment;
        String sedaAchiveUnitId = archiveUnitType.getId();
        String elementGUID = GUIDFactory.newUnitGUID((int)ParameterHelper.getTenantParameter()).toString();
        this.checkAutoAttachmentsByIngestContract();
        boolean bl = isValidAttachment = archiveUnitType.getManagement() != null && archiveUnitType.getManagement().getUpdateOperation() != null && (archiveUnitType.getManagement().getUpdateOperation().getSystemId() != null || archiveUnitType.getManagement().getUpdateOperation().getArchiveUnitIdentifierKey() != null);
        if (isValidAttachment) {
            elementGUID = this.attachArchiveUnitToExisting(archiveUnitType, sedaAchiveUnitId);
        }
        if (archiveUnitType.getArchiveUnitRefId() != null && !jaxbElementParent.isGlobalScope()) {
            if (!archiveUnitType.getArchiveUnitRefId().equals(archiveUnitType.getArchiveUnitRefId().trim())) {
                throw new VitamRuntimeException((Throwable)new ProcessingMalformedDataException("The ArchiveUnitRefId " + archiveUnitType.getArchiveUnitRefId() + " contains line break or spaces"));
            }
            return;
        }
        if (archiveUnitType.getArchiveUnitRefId() != null) {
            String childArchiveUnitRef = archiveUnitType.getArchiveUnitRefId();
            ObjectNode childArchiveUnitNode = (ObjectNode)this.ingestSession.getArchiveUnitTree().get(childArchiveUnitRef);
            if (childArchiveUnitNode == null) {
                childArchiveUnitNode = JsonHandler.createObjectNode();
            }
            ArrayNode parentsField = childArchiveUnitNode.withArray("_up");
            parentsField.addAll((ArrayNode)this.ingestSession.getArchiveUnitTree().get(sedaAchiveUnitId).get("_up"));
            this.ingestSession.getArchiveUnitTree().set(childArchiveUnitRef, (JsonNode)childArchiveUnitNode);
            this.ingestSession.getArchiveUnitTree().without(sedaAchiveUnitId);
            return;
        }
        List archiveUnitOrDataObjectReferenceOrAny = archiveUnitType.getArchiveUnitOrDataObjectReferenceOrDataObjectGroup();
        String groupId = this.buildGraph(sedaAchiveUnitId, elementGUID, archiveUnitOrDataObjectReferenceOrAny);
        ObjectNode archiveUnitNode = (ObjectNode)this.ingestSession.getArchiveUnitTree().get(sedaAchiveUnitId);
        if (archiveUnitNode == null) {
            archiveUnitNode = JsonHandler.createObjectNode();
        }
        this.fillCustodialHistoryReference(archiveUnitType);
        this.ingestSession.getArchiveUnitTree().set(sedaAchiveUnitId, (JsonNode)archiveUnitNode);
        this.ingestSession.getUnitIdToGuid().put(sedaAchiveUnitId, elementGUID);
        this.ingestSession.getGuidToUnitId().put(elementGUID, sedaAchiveUnitId);
        try {
            String operationId = this.handlerIO.getContainerName();
            archiveUnitRoot = this.archiveUnitMapper.map(archiveUnitType, elementGUID, groupId, operationId, this.ingestContext.getWorkflowUnitType().name(), this.ingestContext.getSedaVersion());
            ManagementContractModel managementContractModel = this.ingestContext.getManagementContractModel();
            this.fillManagementContract(archiveUnitRoot, managementContractModel);
            this.persistentIdentifierGenerationService.handlePersistentIdentifierForUnit(archiveUnitRoot, elementGUID, managementContractModel, PersistentIdentifierPolicyTypeEnum.ARK);
        }
        catch (ProcessingMalformedDataException | ProcessingObjectReferenceException e) {
            throw new VitamRuntimeException(e);
        }
        DescriptiveMetadataModel descriptiveMetadataModel = archiveUnitRoot.getArchiveUnit().getDescriptiveMetadataModel();
        this.enhanceSignatures(descriptiveMetadataModel);
        this.replaceInternalReferenceForRelatedObjectReference(sedaAchiveUnitId, descriptiveMetadataModel);
        this.fillListRulesToMap(sedaAchiveUnitId, archiveUnitRoot.getArchiveUnit().getManagement().getAccess());
        this.fillListRulesToMap(sedaAchiveUnitId, archiveUnitRoot.getArchiveUnit().getManagement().getStorage());
        this.fillListRulesToMap(sedaAchiveUnitId, archiveUnitRoot.getArchiveUnit().getManagement().getAppraisal());
        this.fillListRulesToMap(sedaAchiveUnitId, archiveUnitRoot.getArchiveUnit().getManagement().getClassification());
        this.fillListRulesToMap(sedaAchiveUnitId, archiveUnitRoot.getArchiveUnit().getManagement().getDissemination());
        this.fillListRulesToMap(sedaAchiveUnitId, archiveUnitRoot.getArchiveUnit().getManagement().getReuse());
        this.fillListRulesToMap(sedaAchiveUnitId, archiveUnitRoot.getArchiveUnit().getManagement().getHold());
        if (!this.ingestSession.getExistingUnitGuids().contains(elementGUID)) {
            this.storeArchiveUnit(this.unitsDatabase, elementGUID, archiveUnitRoot);
            this.createUnitLifeCycle(elementGUID, this.ingestContext.getOperationId(), this.ingestContext.getTypeProcess());
        }
        archiveUnitType.setManagement(null);
        archiveUnitType.setContent(null);
        archiveUnitType.getArchiveUnitOrDataObjectReferenceOrDataObjectGroup().clear();
        archiveUnitType.setArchiveUnitRefId(sedaAchiveUnitId);
    }

    private void fillManagementContract(ArchiveUnitRoot archiveUnitRoot, ManagementContractModel managementContractModel) {
        if (Objects.isNull(managementContractModel)) {
            return;
        }
        if (ActivationStatus.INACTIVE.equals((Object)managementContractModel.getStatus())) {
            return;
        }
        archiveUnitRoot.getArchiveUnit().setManagementContractId(managementContractModel.getIdentifier());
    }

    private void fillCustodialHistoryReference(ArchiveUnitType archiveUnitType) {
        DescriptiveMetadataContentType content = archiveUnitType.getContent();
        if (content == null || content.getCustodialHistory() == null || content.getCustodialHistory().getCustodialHistoryFile() == null) {
            return;
        }
        CustodialHistoryType custodialHistoryType = content.getCustodialHistory();
        DataObjectRefType dataObjectReference = content.getCustodialHistory().getCustodialHistoryFile();
        String objectGroupReferenceId = dataObjectReference.getDataObjectGroupReferenceId();
        String objectReferenceId = dataObjectReference.getDataObjectReferenceId();
        DataObjectRefType custodialHistoryFile = new DataObjectRefType();
        if (objectGroupReferenceId != null) {
            String objectGroupGuid = this.ingestSession.getObjectGroupIdToGuid().get(objectGroupReferenceId);
            if (objectGroupGuid == null) {
                throw new VitamRuntimeException((Throwable)new ProcessingNotValidLinkingException("Could not find ObjectGroup with Id = " + objectGroupReferenceId));
            }
            custodialHistoryFile.setDataObjectGroupReferenceId(objectGroupGuid);
            custodialHistoryType.setCustodialHistoryFile(custodialHistoryFile);
            content.setCustodialHistory(custodialHistoryType);
            archiveUnitType.setContent(content);
        }
        if (objectReferenceId != null) {
            String objectGroupId = this.ingestSession.getDataObjectIdToObjectGroupId().get(objectReferenceId);
            if (objectGroupId == null) {
                throw new VitamRuntimeException((Throwable)new ProcessingNotValidLinkingException("Could not find Object with Id = " + objectReferenceId));
            }
            custodialHistoryFile.setDataObjectReferenceId(this.ingestSession.getObjectGroupIdToGuid().get(objectGroupId));
            custodialHistoryType.setCustodialHistoryFile(custodialHistoryFile);
            content.setCustodialHistory(custodialHistoryType);
            archiveUnitType.setContent(content);
        }
    }

    private void checkAutoAttachmentsByIngestContract() {
        if (this.attachByIngestContractChecked) {
            return;
        }
        IngestContractModel ingestContract = this.ingestContext.getIngestContract();
        if (ingestContract == null) {
            return;
        }
        if (null == ingestContract.getLinkParentId()) {
            return;
        }
        String checkUnit = "CheckAttachment";
        try {
            JsonNode linkParentUnitResult;
            if (Strings.isNullOrEmpty((String)ingestContract.getLinkParentId())) {
                throw new ProcessingNotFoundException("IngestContract LinParentId mustn't be null or empty", checkUnit, ingestContract.getLinkParentId(), true, ExceptionType.UNIT, "EMPTY_KEY_ATTACHMENT");
            }
            SelectMultiQuery select = new SelectMultiQuery();
            try {
                CompareQuery qr = QueryHelper.eq((String)ParserTokens.PROJECTIONARGS.ID.exactToken(), (String)ingestContract.getLinkParentId());
                select.setQuery((Query)qr);
            }
            catch (InvalidCreateOperationException e) {
                throw new ProcessingNotFoundException("Parse error : " + e.getMessage(), checkUnit, ingestContract.getLinkParentId(), true, ExceptionType.UNIT, "ERROR_PARSE_ATTACHMENT");
            }
            JsonNode linkParentUnitResponse = this.loadExistingArchiveUnit(select);
            JsonNode jsonNode = linkParentUnitResult = linkParentUnitResponse == null ? null : linkParentUnitResponse.get("$results");
            if (linkParentUnitResult == null || linkParentUnitResult.size() == 0) {
                throw new ProcessingNotFoundException("Existing IngestContract LinkParentId :" + ingestContract.getLinkParentId() + ", was not found", checkUnit, ingestContract.getLinkParentId(), true, ExceptionType.UNIT, "NOT_FOUND_ATTACHMENT");
            }
            if (linkParentUnitResult.size() > 1) {
                throw new ProcessingTooManyUnitsFoundException("Existing IngestContract LinkParentId ::" + ingestContract.getLinkParentId() + ", Multiple unit was found", checkUnit, ingestContract.getLinkParentId(), true);
            }
            JsonNode linkParentUnit = linkParentUnitResult.get(0);
            String type = linkParentUnit.get("#unitType").asText();
            UnitType dataUnitType = UnitType.valueOf((String)type);
            UnitType workflowUnitType = this.ingestContext.getWorkflowUnitType();
            if (dataUnitType.ordinal() < workflowUnitType.ordinal()) {
                throw new ProcessingUnitLinkingException("Auto-linking by ingest contract unauthorized to the ArchiveUnit (" + ingestContract.getLinkParentId() + ") type " + dataUnitType + " and current ingest type is " + workflowUnitType, checkUnit, dataUnitType, workflowUnitType);
            }
        }
        catch (ProcessingException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
        finally {
            this.attachByIngestContractChecked = true;
        }
    }

    private void enhanceSignatures(DescriptiveMetadataModel descriptiveMetadataModel) {
        if (descriptiveMetadataModel.getSignature() != null && !descriptiveMetadataModel.getSignature().isEmpty()) {
            for (SignatureTypeModel signature : descriptiveMetadataModel.getSignature()) {
                String signedObjectId = signature.getReferencedObject().getSignedObjectId();
                if (!this.ingestSession.getDataObjectIdToGuid().containsKey(signedObjectId)) continue;
                signature.getReferencedObject().setSignedObjectId(this.ingestSession.getDataObjectIdToGuid().get(signedObjectId));
            }
        }
    }

    private void replaceInternalReferenceForRelatedObjectReference(String archiveUnitId, DescriptiveMetadataModel descriptiveMetadataModel) {
        if (descriptiveMetadataModel.getRelatedObjectReference() != null) {
            RelatedObjectReferenceType relatedObjReference = descriptiveMetadataModel.getRelatedObjectReference();
            this.fillDataObjectOrArchiveUnitReference(archiveUnitId, relatedObjReference.getIsVersionOf());
            this.fillDataObjectOrArchiveUnitReference(archiveUnitId, relatedObjReference.getReplaces());
            this.fillDataObjectOrArchiveUnitReference(archiveUnitId, relatedObjReference.getRequires());
            this.fillDataObjectOrArchiveUnitReference(archiveUnitId, relatedObjReference.getIsPartOf());
            this.fillDataObjectOrArchiveUnitReference(archiveUnitId, relatedObjReference.getReferences());
        }
    }

    private void fillDataObjectOrArchiveUnitReference(String archiveUnitId, List<DataObjectOrArchiveUnitReferenceType> dataObjectOrArchiveUnitReference) {
        Map<String, String> unitIdToGuid = this.ingestSession.getUnitIdToGuid();
        Map<String, Boolean> isThereManifestRelatedReferenceRemained = this.ingestSession.getIsThereManifestRelatedReferenceRemained();
        Map<String, String> dataObjectIdToGuid = this.ingestSession.getDataObjectIdToGuid();
        Map<String, String> objectGroupIdToGuid = this.ingestSession.getObjectGroupIdToGuid();
        for (DataObjectOrArchiveUnitReferenceType relatedObjectReferenceItem : dataObjectOrArchiveUnitReference) {
            String externalReference;
            String getRepositoryObjectPID;
            String repositoryArchiveUnitPID;
            DataObjectRefType dataObjectRefType;
            String archiveUnitRefId = relatedObjectReferenceItem.getArchiveUnitRefId();
            if (archiveUnitRefId != null) {
                if (unitIdToGuid.containsKey(archiveUnitRefId)) {
                    relatedObjectReferenceItem.setArchiveUnitRefId(unitIdToGuid.get(archiveUnitRefId));
                } else {
                    isThereManifestRelatedReferenceRemained.put(archiveUnitId, true);
                }
            }
            if ((dataObjectRefType = relatedObjectReferenceItem.getDataObjectReference()) != null) {
                if (dataObjectRefType.getDataObjectReferenceId() != null) {
                    String dataObjecRefId = dataObjectRefType.getDataObjectReferenceId();
                    if (dataObjectIdToGuid.containsKey(dataObjecRefId)) {
                        dataObjectRefType.setDataObjectReferenceId(dataObjectIdToGuid.get(dataObjecRefId));
                    } else {
                        isThereManifestRelatedReferenceRemained.put(archiveUnitId, true);
                    }
                }
                if (dataObjectRefType.getDataObjectGroupReferenceId() != null) {
                    String dataObjecGroupRefId = dataObjectRefType.getDataObjectGroupReferenceId();
                    if (objectGroupIdToGuid.containsKey(dataObjecGroupRefId)) {
                        dataObjectRefType.setDataObjectGroupReferenceId(objectGroupIdToGuid.get(dataObjecGroupRefId));
                    } else {
                        isThereManifestRelatedReferenceRemained.put(archiveUnitId, true);
                    }
                }
            }
            if ((repositoryArchiveUnitPID = relatedObjectReferenceItem.getRepositoryArchiveUnitPID()) != null) {
                if (dataObjectIdToGuid.containsKey(repositoryArchiveUnitPID)) {
                    relatedObjectReferenceItem.setRepositoryArchiveUnitPID(objectGroupIdToGuid.get(repositoryArchiveUnitPID));
                } else {
                    isThereManifestRelatedReferenceRemained.put(archiveUnitId, true);
                }
            }
            if ((getRepositoryObjectPID = relatedObjectReferenceItem.getRepositoryObjectPID()) != null) {
                if (dataObjectIdToGuid.containsKey(getRepositoryObjectPID)) {
                    relatedObjectReferenceItem.setRepositoryObjectPID(objectGroupIdToGuid.get(getRepositoryObjectPID));
                } else {
                    isThereManifestRelatedReferenceRemained.put(archiveUnitId, true);
                }
            }
            if ((externalReference = relatedObjectReferenceItem.getExternalReference()) == null) continue;
            relatedObjectReferenceItem.setExternalReference(externalReference);
        }
    }

    private String attachArchiveUnitToExisting(ArchiveUnitType archiveUnitType, String archiveUnitId) {
        Object existingArchiveUnitGuid = archiveUnitType.getManagement().getUpdateOperation().getSystemId();
        IngestContractModel ingestContract = this.ingestContext.getIngestContract();
        UnitType workflowUnitType = this.ingestContext.getWorkflowUnitType();
        try {
            JsonNode existingData;
            JsonNode result;
            String metadataValue;
            String metadataName;
            if (ingestContract != null && IngestContractCheckState.UNAUTHORIZED.equals((Object)ingestContract.getCheckParentLink())) {
                throw new ProcessingAttachmentUnauthorizedException("ingest contract does not allow to attach archive unit to existing");
            }
            boolean isGuid = false;
            if (null != existingArchiveUnitGuid) {
                isGuid = true;
                metadataName = ParserTokens.PROJECTIONARGS.ID.exactToken();
                metadataValue = existingArchiveUnitGuid;
                try {
                    GUIDReader.getGUID((String)existingArchiveUnitGuid);
                }
                catch (InvalidGuidOperationException e) {
                    String keyValueUnitId = "[MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "]";
                    throw new ProcessingNotFoundException("Unit " + archiveUnitId + ": [" + keyValueUnitId + "] is not a valid systemId [guid]", archiveUnitId, (String)existingArchiveUnitGuid, false, ExceptionType.UNIT, "INVALID_GUID_ATTACHMENT");
                }
            } else {
                ArchiveUnitIdentifierKeyType archiveUnitIdentifier = archiveUnitType.getManagement().getUpdateOperation().getArchiveUnitIdentifierKey();
                metadataName = archiveUnitIdentifier.getMetadataName();
                metadataValue = archiveUnitIdentifier.getMetadataValue();
            }
            String keyValueUnitId = "[MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "]";
            if (null == existingArchiveUnitGuid) {
                existingArchiveUnitGuid = keyValueUnitId;
            }
            JsonNode jsonNode = result = (existingData = this.loadExistingArchiveUnitByKeyValue(metadataName, metadataValue, archiveUnitId)) == null ? null : existingData.get("$results");
            if (result == null || result.size() == 0) {
                throw new ProcessingNotFoundException("Existing Unit " + archiveUnitId + ":" + keyValueUnitId + ", was not found", archiveUnitId, (String)existingArchiveUnitGuid, isGuid, ExceptionType.UNIT, "NOT_FOUND_ATTACHMENT");
            }
            if (result.size() > 1) {
                throw new ProcessingTooManyUnitsFoundException("Unit " + archiveUnitId + ":" + keyValueUnitId + ", Multiple unit was found", archiveUnitId, (String)existingArchiveUnitGuid, isGuid);
            }
            JsonNode unitInDB = result.get(0);
            String type = unitInDB.get("#unitType").asText();
            UnitType dataUnitType = UnitType.valueOf((String)type);
            if (this.ingestContractRestrictAttachment(ingestContract, unitInDB)) {
                throw new ProcessingUnitLinkingException("archive unit is not equals or is not descending from allowed units : " + ingestContract.getCheckParentId(), archiveUnitId, null, workflowUnitType);
            }
            existingArchiveUnitGuid = unitInDB.get("#id").asText();
            this.ingestSession.getExistingUnitGuids().add((String)existingArchiveUnitGuid);
            if (unitInDB.get("#object") != null && unitInDB.get("#object").asText() != null) {
                this.ingestSession.getExistingUnitIdWithExistingObjectGroup().put((String)existingArchiveUnitGuid, unitInDB.get("#object").asText());
            } else {
                DataObjectReference dataObjectReference = this.archiveUnitMapper.mapAndValidateDataObjectReference(archiveUnitType);
                if (null != dataObjectReference) {
                    String got = dataObjectReference.getDataObjectGroupReferenceId();
                    throw new ProcessingObjectGroupLinkingException("Linking object (" + got + ") not allowed for unit (" + (String)existingArchiveUnitGuid + ") without ObjectGroup", (String)existingArchiveUnitGuid, got);
                }
            }
            if (dataUnitType.ordinal() < workflowUnitType.ordinal()) {
                throw new ProcessingUnitLinkingException("Linking Unauthorized to the ArchiveUnit (" + (String)existingArchiveUnitGuid + ") type " + dataUnitType + " and current ingest type is " + workflowUnitType, archiveUnitId, dataUnitType, workflowUnitType);
            }
            if (!UnitType.HOLDING_UNIT.equals((Object)dataUnitType)) {
                ArrayNode originAgencies = (ArrayNode)unitInDB.get(VitamFieldsHelper.originatingAgencies());
                ArrayList<String> originatingAgencyList = new ArrayList<String>();
                for (JsonNode agency : originAgencies) {
                    originatingAgencyList.add(agency.asText());
                }
                this.ingestSession.getOriginatingAgencies().addAll(originatingAgencyList);
            }
        }
        catch (ProcessingException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
        return existingArchiveUnitGuid;
    }

    private boolean ingestContractRestrictAttachment(IngestContractModel ingestContract, JsonNode unitInDB) {
        JsonNode ascendants = unitInDB.get(ParserTokens.PROJECTIONARGS.ALLUNITUPS.exactToken());
        String unitId = unitInDB.get(ParserTokens.PROJECTIONARGS.ID.exactToken()).asText();
        if (ingestContract == null || ingestContract.getCheckParentId() == null || ingestContract.getCheckParentId().isEmpty() || ingestContract.getCheckParentId().contains(unitId)) {
            return false;
        }
        for (JsonNode ascendant : ascendants) {
            if (!ingestContract.getCheckParentId().contains(ascendant.asText())) continue;
            return false;
        }
        return true;
    }

    private void fillListRulesToMap(String archiveUnitId, RuleCategoryModel ruleCategory) {
        if (ruleCategory == null) {
            return;
        }
        Set rulesId = ruleCategory.getRules().stream().map(RuleModel::getRule).filter(item -> !Strings.isNullOrEmpty((String)item)).collect(Collectors.toSet());
        if (rulesId.size() == 0) {
            return;
        }
        Map<String, Set<String>> unitIdToSetOfRuleId = this.ingestSession.getUnitIdToSetOfRuleId();
        if (!unitIdToSetOfRuleId.containsKey(archiveUnitId)) {
            unitIdToSetOfRuleId.put(archiveUnitId, new HashSet());
        }
        unitIdToSetOfRuleId.get(archiveUnitId).addAll(rulesId);
    }

    private String buildGraph(String archiveUnitId, String archiveUnitGUID, List<Object> archiveUnitOrDataObjectReferenceOrAny) {
        String groupGUID = null;
        for (Object o : archiveUnitOrDataObjectReferenceOrAny) {
            if (!(o instanceof JAXBElement)) continue;
            JAXBElement element = (JAXBElement)o;
            if (element.getDeclaredType().isAssignableFrom(ArchiveUnitType.class)) {
                this.fillArchiveUnitTree(archiveUnitId, (ArchiveUnitType)element.getValue());
                continue;
            }
            if (element.getDeclaredType().isAssignableFrom(DataObjectRefType.class)) {
                groupGUID = this.fillDataObjectGroup(archiveUnitId, element);
                if (!this.ingestSession.getExistingUnitIdWithExistingObjectGroup().containsKey(archiveUnitGUID)) continue;
                this.ingestSession.getExistingGOTGUIDToNewGotGUIDInAttachment().put(this.ingestSession.getExistingUnitIdWithExistingObjectGroup().get(archiveUnitGUID), groupGUID);
                continue;
            }
            if (!element.getDeclaredType().isAssignableFrom(ObjectGroupRefType.class)) continue;
            groupGUID = this.fillObjectGroup(archiveUnitId, element);
        }
        return groupGUID;
    }

    private String fillDataObjectGroup(String archiveUnitId, JAXBElement<?> element) {
        DataObjectRefType dataObjectRefType = (DataObjectRefType)element.getValue();
        Map<String, String> objectGroupIdToGuid = this.ingestSession.getObjectGroupIdToGuid();
        Map<String, String> unitIdToGroupId = this.ingestSession.getUnitIdToGroupId();
        Map<String, List<String>> objectGroupIdToUnitId = this.ingestSession.getObjectGroupIdToUnitId();
        Map<String, GotObj> dataObjectIdWithoutObjectGroupId = this.ingestSession.getDataObjectIdWithoutObjectGroupId();
        if (dataObjectRefType.getDataObjectReferenceId() != null) {
            String objRefId = dataObjectRefType.getDataObjectReferenceId();
            unitIdToGroupId.put(archiveUnitId, objRefId);
            if (objectGroupIdToUnitId.get(objRefId) == null) {
                ArrayList<String> archiveUnitList = new ArrayList<String>();
                archiveUnitList.add(archiveUnitId);
                if (dataObjectIdWithoutObjectGroupId.containsKey(objRefId)) {
                    GotObj gotObj = dataObjectIdWithoutObjectGroupId.get(objRefId);
                    String gotId = gotObj.getGotId();
                    objectGroupIdToUnitId.put(gotId, archiveUnitList);
                    unitIdToGroupId.put(archiveUnitId, gotId);
                    gotObj.setVisited(true);
                    dataObjectIdWithoutObjectGroupId.put(objRefId, gotObj);
                }
            } else {
                objectGroupIdToUnitId.get(objRefId).add(archiveUnitId);
            }
            try {
                return objectGroupIdToGuid.get(this.getNewGdoIdFromGdoByUnit(objRefId));
            }
            catch (ProcessingManifestReferenceException e) {
                throw new RuntimeException(e);
            }
        }
        if (dataObjectRefType.getDataObjectGroupReferenceId() != null) {
            List<Object> archiveUnitList;
            String groupId = dataObjectRefType.getDataObjectGroupReferenceId();
            unitIdToGroupId.put(archiveUnitId, groupId);
            if (objectGroupIdToUnitId.get(groupId) == null) {
                archiveUnitList = new ArrayList<String>();
                archiveUnitList.add(archiveUnitId);
                if (!dataObjectIdWithoutObjectGroupId.containsKey(groupId)) {
                    objectGroupIdToUnitId.put(groupId, archiveUnitList);
                }
            } else {
                archiveUnitList = objectGroupIdToUnitId.get(groupId);
                archiveUnitList.add(archiveUnitId);
                objectGroupIdToUnitId.put(groupId, archiveUnitList);
            }
            try {
                return objectGroupIdToGuid.get(this.getNewGdoIdFromGdoByUnit(unitIdToGroupId.get(archiveUnitId)));
            }
            catch (ProcessingManifestReferenceException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private String fillObjectGroup(String archiveUnitId, JAXBElement<?> element) {
        ObjectGroupRefType dataObjectRefType = (ObjectGroupRefType)element.getValue();
        if (dataObjectRefType.getDataObjectGroupExistingReferenceId() != null) {
            List<Object> archiveUnitList;
            String groupId = dataObjectRefType.getDataObjectGroupExistingReferenceId();
            JsonNode existingObjectGroup = this.loadExistingObjectGroup(groupId);
            if (existingObjectGroup == null || existingObjectGroup.get("$results") == null || existingObjectGroup.get("$results").size() == 0) {
                throw new RuntimeException((Throwable)new ProcessingNotFoundException("Existing ObjectGroup " + groupId + " was not found for AU " + archiveUnitId, archiveUnitId, groupId, true, ExceptionType.GOT, "NOT_FOUND_ATTACHMENT"));
            }
            this.ingestSession.getUnitIdToGroupId().put(archiveUnitId, groupId);
            this.ingestSession.getObjectGroupIdToGuid().put(groupId, groupId);
            Map<String, List<String>> objectGroupIdToUnitId = this.ingestSession.getObjectGroupIdToUnitId();
            if (objectGroupIdToUnitId.get(groupId) == null) {
                archiveUnitList = new ArrayList<String>();
                archiveUnitList.add(archiveUnitId);
                if (!this.ingestSession.getDataObjectIdWithoutObjectGroupId().containsKey(groupId)) {
                    objectGroupIdToUnitId.put(groupId, archiveUnitList);
                }
            } else {
                archiveUnitList = objectGroupIdToUnitId.get(groupId);
                archiveUnitList.add(archiveUnitId);
                objectGroupIdToUnitId.put(groupId, archiveUnitList);
            }
            JsonNode ogInDB = existingObjectGroup.get("$results").get(0);
            ObjectNode work = JsonHandler.createObjectNode();
            ObjectNode originalOGGraphData = JsonHandler.createObjectNode();
            JsonNode ops = ogInDB.get(ParserTokens.PROJECTIONARGS.OPERATIONS.exactToken());
            Map<String, JsonNode> existingGOTs = this.ingestSession.getExistingGOTs();
            if (null != ops && ops.toString().contains(this.ingestContext.getOperationId())) {
                existingGOTs.put(groupId, null);
                return groupId;
            }
            originalOGGraphData.set("_ops", ops);
            originalOGGraphData.put("_opi", this.ingestContext.getOperationId());
            originalOGGraphData.set("_sps", ogInDB.get(ParserTokens.PROJECTIONARGS.ORIGINATING_AGENCIES.exactToken()));
            originalOGGraphData.set("_up", ogInDB.get(ParserTokens.PROJECTIONARGS.UNITUPS.exactToken()));
            work.set("_existing", (JsonNode)originalOGGraphData);
            ObjectNode existingOG = JsonHandler.createObjectNode();
            existingOG.set("_work", (JsonNode)work);
            existingGOTs.put(groupId, (JsonNode)existingOG);
            try {
                File tmpFile = this.handlerIO.getNewLocalFile(groupId + ".json");
                JsonHandler.writeAsFile((Object)existingOG, (File)tmpFile);
                this.handlerIO.transferFileToWorkspace("UpdateObjectGroup/" + groupId + ".json", tmpFile, true, true);
            }
            catch (InvalidParseOperationException | ProcessingException e) {
                throw new RuntimeException(new ProcessingException("Error while saving existing got to workspace", e));
            }
            return groupId;
        }
        return null;
    }

    private void fillArchiveUnitTree(String archiveUnitId, ArchiveUnitType archiveUnitType) {
        String childArchiveUnitRef = archiveUnitType.getArchiveUnitRefId();
        String childArchiveUnitRef_guid = this.ingestSession.getUnitIdToGuid().get(childArchiveUnitRef);
        if (this.ingestSession.getExistingUnitGuids().contains(childArchiveUnitRef_guid)) {
            throw new RuntimeException(new ProcessingManifestReferenceException("The existing unit with guid [" + childArchiveUnitRef_guid + "] and manifest id [" + childArchiveUnitRef + "] should not have as parent a manifest unit id [" + archiveUnitId + "] ", childArchiveUnitRef, childArchiveUnitRef_guid, archiveUnitId));
        }
        ObjectNode childArchiveUnitNode = (ObjectNode)this.ingestSession.getArchiveUnitTree().get(childArchiveUnitRef);
        if (childArchiveUnitNode == null) {
            childArchiveUnitNode = JsonHandler.createObjectNode();
        }
        ArrayNode parentsField = childArchiveUnitNode.withArray("_up");
        parentsField.add(archiveUnitId);
        this.ingestSession.getArchiveUnitTree().set(childArchiveUnitRef, (JsonNode)childArchiveUnitNode);
    }

    private void storeArchiveUnit(JsonLineDataBase unitsDatabase, String elementGuid, ArchiveUnitRoot archiveUnitRoot) {
        JsonNode jsonNode = (JsonNode)VitamObjectMapper.getSerializationObjectMapper().convertValue((Object)archiveUnitRoot, JsonNode.class);
        unitsDatabase.write(elementGuid, jsonNode);
    }

    private String getNewGdoIdFromGdoByUnit(String objIdRefByUnit) throws ProcessingManifestReferenceException {
        Map<String, GotObj> dataObjectIdWithoutObjectGroupId = this.ingestSession.getDataObjectIdWithoutObjectGroupId();
        String gotGuid = dataObjectIdWithoutObjectGroupId.get(objIdRefByUnit) != null ? dataObjectIdWithoutObjectGroupId.get(objIdRefByUnit).getGotId() : null;
        Map<String, String> dataObjectIdToObjectGroupId = this.ingestSession.getDataObjectIdToObjectGroupId();
        if (Strings.isNullOrEmpty((String)dataObjectIdToObjectGroupId.get(objIdRefByUnit)) && !Strings.isNullOrEmpty((String)gotGuid)) {
            LOGGER.debug("The data object id " + objIdRefByUnit + ", is defined without the group object id " + dataObjectIdWithoutObjectGroupId.get(objIdRefByUnit) + ". The technical group object guid is " + gotGuid);
            return gotGuid;
        }
        if (!Strings.isNullOrEmpty((String)dataObjectIdToObjectGroupId.get(objIdRefByUnit))) {
            LOGGER.debug("The data object id " + dataObjectIdWithoutObjectGroupId.get(objIdRefByUnit) + " referenced defined with the group object id " + objIdRefByUnit);
            return dataObjectIdToObjectGroupId.get(objIdRefByUnit);
        }
        if (dataObjectIdToObjectGroupId.containsValue(objIdRefByUnit)) {
            return objIdRefByUnit;
        }
        throw new ProcessingManifestReferenceException("The group id " + objIdRefByUnit + " doesn't reference a data object or got and it not include in data object", objIdRefByUnit, ExceptionType.GOT);
    }

    private void createUnitLifeCycle(String unitGuid, String containerId, LogbookTypeProcess logbookTypeProcess) {
        LogbookLifeCycleUnitParameters logbookLifecycleUnitParameters = (LogbookLifeCycleUnitParameters)this.initLogbookLifeCycleParameters(unitGuid, true, false);
        logbookLifecycleUnitParameters.setFinalStatus(LFC_INITIAL_CREATION_EVENT_TYPE, null, StatusCode.OK, null, new String[0]);
        logbookLifecycleUnitParameters.putParameterValue(LogbookParameterName.eventIdentifierProcess, containerId);
        logbookLifecycleUnitParameters.putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString());
        logbookLifecycleUnitParameters.putParameterValue(LogbookParameterName.eventTypeProcess, logbookTypeProcess.name());
        this.ingestSession.getGuidToLifeCycleParameters().put(unitGuid, (LogbookLifeCycleParameters)logbookLifecycleUnitParameters);
    }

    private LogbookParameters initLogbookLifeCycleParameters(String guid, boolean isArchive, boolean isObjectGroup) {
        LogbookParameters logbookLifeCycleParameters = (LogbookParameters)this.ingestSession.getGuidToLifeCycleParameters().get(guid);
        if (logbookLifeCycleParameters == null) {
            logbookLifeCycleParameters = isArchive ? LogbookParameterHelper.newLogbookLifeCycleUnitParameters() : (isObjectGroup ? LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters() : LogbookParameterHelper.newLogbookOperationParameters());
            logbookLifeCycleParameters.putParameterValue(LogbookParameterName.objectIdentifier, guid);
        }
        return logbookLifeCycleParameters;
    }

    private JsonNode loadExistingArchiveUnitByKeyValue(String metadataName, String metadataValue, String archiveUnitId) throws ProcessingException {
        if (metadataName.isEmpty() || metadataValue.isEmpty()) {
            throw new ProcessingNotFoundException("Unit " + archiveUnitId + ": [MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "] are required values", archiveUnitId, "[MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "]", false, ExceptionType.UNIT, "EMPTY_KEY_ATTACHMENT");
        }
        SelectMultiQuery select = new SelectMultiQuery();
        try {
            CompareQuery qr = QueryHelper.eq((String)metadataName, (String)metadataValue);
            select.setQuery((Query)qr);
        }
        catch (IllegalStateException e) {
            throw new ProcessingNotFoundException("Unit " + archiveUnitId + ":  [MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "] : " + e.getMessage(), archiveUnitId, "[MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "]", false, ExceptionType.UNIT, "NULL_LINK_PARENT_ID_ATTACHMENT");
        }
        catch (InvalidCreateOperationException e) {
            throw new ProcessingNotFoundException("Unit " + archiveUnitId + ":  [MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "] : " + e.getMessage(), archiveUnitId, "[MetadataName:" + metadataName + ", MetadataValue : " + metadataValue + "]", false, ExceptionType.UNIT, "ERROR_PARSE_ATTACHMENT");
        }
        return this.loadExistingArchiveUnit(select);
    }

    private JsonNode loadExistingArchiveUnit(SelectMultiQuery selectMultiQuery) throws ProcessingException {
        JsonNode jsonNode;
        block9: {
            MetaDataClient metadataClient = this.metaDataClientFactory.getClient();
            try {
                ObjectNode projection = JsonHandler.createObjectNode();
                ObjectNode fields = JsonHandler.createObjectNode();
                fields.put(ParserTokens.PROJECTIONARGS.UNITTYPE.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.ID.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.ORIGINATING_AGENCIES.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.ORIGINATING_AGENCY.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.OBJECT.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.ALLUNITUPS.exactToken(), 1);
                projection.set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)fields);
                selectMultiQuery.setProjection((JsonNode)projection);
                jsonNode = metadataClient.selectUnits((JsonNode)selectMultiQuery.getFinalSelect());
                if (metadataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metadataClient != null) {
                        try {
                            metadataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MetaDataException e) {
                    throw new ProcessingException((Throwable)e);
                }
                catch (InvalidParseOperationException e) {
                    throw new ProcessingException("Json Parse error ", (Throwable)e);
                }
            }
            metadataClient.close();
        }
        return jsonNode;
    }

    private JsonNode loadExistingObjectGroup(String objectGroupId) {
        JsonNode jsonNode;
        block9: {
            MetaDataClient metadataClient = this.metaDataClientFactory.getClient();
            try {
                SelectParserMultiple selectRequest = new SelectParserMultiple();
                SelectMultiQuery request = selectRequest.getRequest().reset();
                ObjectNode projection = JsonHandler.createObjectNode();
                ObjectNode fields = JsonHandler.createObjectNode();
                fields.put(ParserTokens.PROJECTIONARGS.UNITUPS.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.ID.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.ORIGINATING_AGENCIES.exactToken(), 1);
                fields.put(ParserTokens.PROJECTIONARGS.OPERATIONS.exactToken(), 1);
                projection.set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)fields);
                request.setProjection((JsonNode)projection);
                jsonNode = metadataClient.selectObjectGrouptbyId((JsonNode)request.getFinalSelect(), objectGroupId);
                if (metadataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metadataClient != null) {
                        try {
                            metadataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MetaDataException e) {
                    throw new RuntimeException(new ProcessingException((Throwable)e));
                }
                catch (InvalidParseOperationException e) {
                    throw new RuntimeException(new ProcessingException("Existing ObjectGroup " + objectGroupId + " was not found"));
                }
            }
            metadataClient.close();
        }
        return jsonNode;
    }
}

