/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.backup;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.exception.BackupServiceException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.InputStream;

public class BackupService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BackupService.class);
    private final WorkspaceClientFactory workspaceClientFactory;
    private final StorageClientFactory storageClientFactory;

    public BackupService() {
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        this.storageClientFactory = StorageClientFactory.getInstance();
    }

    @VisibleForTesting
    public BackupService(WorkspaceClientFactory workspaceClientFactory, StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    public StoredInfoResult backupFromWorkspace(String workspaceUri, DataCategory storageCollectionType, String objectName) throws BackupServiceException {
        return this.storeIntoOffers(VitamThreadUtils.getVitamSession().getRequestId(), workspaceUri, storageCollectionType, objectName, VitamConfiguration.getDefaultStrategy());
    }

    public StoredInfoResult backup(InputStream stream, DataCategory storageCollectionType, String uri) throws BackupServiceException {
        return this.backup(stream, storageCollectionType, uri, VitamConfiguration.getDefaultStrategy());
    }

    /*
     * Exception decompiling
     */
    public StoredInfoResult backup(InputStream stream, DataCategory storageCollectionType, String uri, String strategyId) throws BackupServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StoredInfoResult storeIntoOffers(String workspaceContainer, String workspaceUri, DataCategory storageCollectionType, String objectName, String strategyId) throws BackupServiceException {
        StoredInfoResult storedInfoResult;
        block8: {
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                ObjectDescription description = new ObjectDescription();
                description.setWorkspaceContainerGUID(workspaceContainer);
                description.setWorkspaceObjectURI(workspaceUri);
                storedInfoResult = storageClient.storeFileFromWorkspace(strategyId, storageCollectionType, objectName, description);
                if (storageClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException e) {
                    throw new BackupServiceException("Unable to store file from workSpace to storage " + workspaceUri + "/" + workspaceUri + " -> " + storageCollectionType.getFolder() + "/" + objectName, e);
                }
            }
            storageClient.close();
        }
        return storedInfoResult;
    }
}

