/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.core;

import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.digest.DigestTypeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.ingest.external.core.exception.ManifestDigestValidationException;
import java.io.IOException;
import java.io.InputStream;

public class ManifestDigestValidator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ManifestDigestValidator.class);

    public void checkManifestDigest(InputStream manifestInputStream, String manifestDigestAlgo, String manifestDigestValue) throws ManifestDigestValidationException, IOException {
        DigestType digestType;
        if (manifestDigestAlgo == null && manifestDigestValue == null) {
            LOGGER.debug("No manifest log check required");
            return;
        }
        if (manifestDigestAlgo == null) {
            throw new ManifestDigestValidationException("Missing manifest algorithm");
        }
        if (manifestDigestValue == null) {
            throw new ManifestDigestValidationException("Missing manifest digest");
        }
        try {
            digestType = DigestType.fromValue((String)manifestDigestAlgo);
        }
        catch (DigestTypeException e) {
            throw new ManifestDigestValidationException("Invalid manifest digest algorithm " + manifestDigestAlgo, e);
        }
        Digest digest = new Digest(digestType);
        digest.update(manifestInputStream);
        if (!digest.digestHex().equals(manifestDigestValue)) {
            throw new ManifestDigestValidationException("Manifest digest validation failed. Expected digest is '" + manifestDigestValue + "', actual digest '" + digest.digestHex() + "' (" + digestType.getName() + ")");
        }
        LOGGER.debug("Manifest digest validation succeeded");
    }
}

