/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.core;

import fr.gouv.vitam.common.CharsetUtils;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.format.identification.FormatIdentifierFactory;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.common.server.application.AsyncInputStreamHelper;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.compress.VitamArchiveStreamFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.common.config.IngestExternalConfiguration;
import fr.gouv.vitam.ingest.external.core.IngestExternal;
import fr.gouv.vitam.ingest.external.core.ManifestDigestValidator;
import fr.gouv.vitam.ingest.external.core.ManifestFileName;
import fr.gouv.vitam.ingest.external.core.PreUploadResume;
import fr.gouv.vitam.ingest.external.core.exception.ManifestDigestValidationException;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClient;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientFactory;
import fr.gouv.vitam.logbook.common.MessageLogbookEngineHelper;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.common.WorkspaceFileSystem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;

public class IngestExternalImpl
implements IngestExternal {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestExternalImpl.class);
    public static final String INGEST_INT_UPLOAD = "STP_UPLOAD_SIP";
    private static final String CAN_NOT_SCAN_VIRUS = "Can not scan virus";
    private static final String CAN_NOT_STORE_FILE = "Can not store file";
    private static final String IS_NOT_SUPPORTED = " is not supported";
    private static final String SIP_FORMAT = "SIP format :";
    private static final String SIP_WRONG_FORMAT = "SIP Wrong format : ";
    private static final String BEGIN_SIEG_FRIED_FORMAT_IDENTIFICATION = "Begin siegFried format identification";
    private static final String CAN_NOT_READ_FILE = "Can not read file";
    private static final int STATUS_ANTIVIRUS_NOT_PERFORMED = 3;
    private static final int STATUS_ANTIVIRUS_EXCEPTION_OCCURRED = -1;
    private static final int STATUS_ANTIVIRUS_KO = 2;
    private static final int STATUS_ANTIVIRUS_WARNING = 1;
    private static final int STATUS_ANTIVIRUS_OK = 0;
    private static final String FORMAT_IDENTIFIER_ID = "siegfried-local";
    private static final String PRONOM_NAMESPACE = "pronom";
    private final IngestExternalConfiguration config;
    private final FormatIdentifierFactory formatIdentifierFactory;
    private final IngestInternalClientFactory ingestInternalClientFactory;
    private final ManifestDigestValidator manifestDigestValidator;

    public IngestExternalImpl(IngestExternalConfiguration config, FormatIdentifierFactory formatIdentifierFactory, IngestInternalClientFactory ingestInternalClientFactory, ManifestDigestValidator manifestDigestValidator) {
        this.config = config;
        this.formatIdentifierFactory = formatIdentifierFactory;
        this.ingestInternalClientFactory = ingestInternalClientFactory;
        this.manifestDigestValidator = manifestDigestValidator;
    }

    @Override
    public PreUploadResume preUploadAndResume(InputStream input, String workflowIdentifier, GUID guid, String xAction, AsyncResponse asyncResponse) throws IngestExternalException, VitamClientException {
        PreUploadResume preUploadResume;
        block13: {
            ParametersChecker.checkParameter((String)"input is a mandatory parameter", (Object[])new Object[]{input});
            VitamThreadUtils.getVitamSession().setRequestId(guid);
            LogbookOperationsClientHelper helper = new LogbookOperationsClientHelper();
            IngestInternalClient ingestClient = this.ingestInternalClientFactory.getClient();
            try {
                Optional optional = ingestClient.getWorkflowDetails(workflowIdentifier);
                if (optional.isEmpty()) {
                    throw new WorkflowNotFoundException("Workflow " + workflowIdentifier + " not found");
                }
                WorkFlow workflow = (WorkFlow)optional.get();
                LogbookTypeProcess logbookTypeProcess = LogbookTypeProcess.valueOf((String)workflow.getTypeProc());
                MessageLogbookEngineHelper messageLogbookEngineHelper = new MessageLogbookEngineHelper(logbookTypeProcess);
                LogbookOperationParameters startedParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)guid, (String)workflow.getIdentifier(), (GUID)guid, (LogbookTypeProcess)logbookTypeProcess, (StatusCode)StatusCode.STARTED, (String)(messageLogbookEngineHelper.getLabelOp(workflow.getIdentifier(), StatusCode.STARTED, new Object[0]) + " : " + guid.toString()), (GUID)guid);
                startedParameters.getMapParameters().put(LogbookParameterName.objectIdentifierIncome, guid.getId());
                helper.createDelegate(startedParameters);
                try {
                    LOGGER.debug("Initialize Workflow operation (" + guid + ") ... ");
                    ingestClient.initWorkflow(workflow);
                    ingestClient.uploadInitialLogbook((Iterable)helper.removeCreateDelegate(guid.getId()));
                }
                catch (VitamException e) {
                    throw new IngestExternalException((Throwable)e);
                }
                LOGGER.debug("Workflow initialized operation (" + guid + ") ... ");
                WorkspaceFileSystem workspaceFileSystem = new WorkspaceFileSystem(new StorageConfiguration().setStoragePath(this.config.getPath()));
                workspaceFileSystem.createContainer(guid.toString());
                LOGGER.debug("Put file in local disk to be analysed operation (" + guid + ")");
                workspaceFileSystem.putObject(guid.getId(), guid.getId(), input);
                LOGGER.debug("Responds to asyncResponse the continue in background operation (" + guid + ")");
                AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.ACCEPTED).header("X-Request-Id", (Object)guid.getId()).header("X-Global-Execution-State", (Object)ProcessState.PAUSE).header("X-Global-Execution-Status", (Object)StatusCode.UNKNOWN).build(), (InputStream)input);
                ingestClient.updateOperationActionProcess(xAction, guid.getId());
                preUploadResume = new PreUploadResume(workflow, workspaceFileSystem);
                if (ingestClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (ingestClient != null) {
                        try {
                            ingestClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientAlreadyExistsException ex) {
                    throw new IngestExternalException((Throwable)ex);
                }
                catch (IOException ex) {
                    LOGGER.error("Cannot load WorkspaceFileSystem ", (Throwable)ex);
                    throw new IllegalStateException(ex);
                }
                catch (ContentAddressableStorageException e) {
                    LOGGER.error(CAN_NOT_STORE_FILE, (Throwable)e);
                    throw new IngestExternalException((Throwable)e);
                }
            }
            ingestClient.close();
        }
        return preUploadResume;
    }

    /*
     * Exception decompiling
     */
    @Override
    public StatusCode upload(PreUploadResume preUploadResume, String xAction, GUID guid, String manifestDigestValue, String manifestDigestAlgo) throws IngestExternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FormatIdentifierResponse getFirstPronomFormat(List<FormatIdentifierResponse> formats) {
        for (FormatIdentifierResponse format : formats) {
            if (!PRONOM_NAMESPACE.equals(format.getMatchedNamespace())) continue;
            return format;
        }
        return null;
    }

    public void handleResponseWithATR(GUID operationId, AsyncResponse asyncResponse, String entity) {
        AsyncInputStreamHelper responseHelper = new AsyncInputStreamHelper(asyncResponse, (InputStream)new ByteArrayInputStream(entity.getBytes(CharsetUtils.UTF8)));
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("application/octet-stream").header("X-Request-Id", (Object)operationId.getId()).header("X-Global-Execution-State", (Object)ProcessState.COMPLETED).header("X-Global-Execution-Status", (Object)StatusCode.FATAL);
        responseHelper.writeResponse(responseBuilder);
    }

    private ManifestFileName checkManifestFile(InputStream in, String mimeType, String manifestDigestAlgo, String manifestDigestValue) throws IOException, ArchiveException, ManifestDigestValidationException {
        ManifestFileName manifestFileName = new ManifestFileName();
        try (ArchiveInputStream archiveInputStream = new VitamArchiveStreamFactory().createArchiveInputStream(CommonMediaType.valueOf((String)mimeType), in);){
            ArchiveEntry entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                LOGGER.debug("SIP Files : " + entry.getName());
                if (!archiveInputStream.canReadEntryData(entry) || entry.isDirectory() || entry.getName().split("/").length != 1) continue;
                manifestFileName.setFileName(entry.getName());
                if (!entry.getName().matches("^([a-zA-Z0-9_\\-]{0,56}[_-]{1}){0,1}(manifest.xml)\\b")) continue;
                manifestFileName.setManifestFile(true);
                this.manifestDigestValidator.checkManifestDigest((InputStream)archiveInputStream, manifestDigestAlgo, manifestDigestValue);
                break;
            }
        }
        return manifestFileName;
    }
}

