/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.core;

import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;

public class AtrKoBuilder {
    private static final String ATR_KO_DEFAULT_XML = "ATR_KO_DEFAULT.xml";
    private static final String DATE = "#MADATE#";
    private static final String MESSAGE_IDENTIFIER = "#MESSAGE_IDENTIFIER#";
    private static final String ARCHIVAL_AGENCY = "#ARCHIVAL_AGENCY#";
    private static final String TRANSFERRING_AGENCY = "#TRANSFERRING_AGENCY#";
    private static final String COMMENT = "#COMMENT#";
    private static final String EVENT_TYPE = "#EVENT_TYPE#";
    private static final String EVENT_TYPE_CODE = "#EVENT_TYPE_CODE#";
    private static final String EVENT_DATE_TIME = "#EVENT_DATE_TIME#";
    private static final String OUTCOME = "#OUTCOME#";
    private static final String OUTCOME_DETAIL = "#OUTCOME_DETAIL#";
    private static final String OUTCOME_DETAIL_MESSAGE = "#OUTCOME_DETAIL_MESSAGE#";

    private AtrKoBuilder() {
    }

    public static String buildAtrKo(String messageIdentifier, String archivalAgency, String transferringAgency, String eventType, String addedMessage, StatusCode code, LocalDateTime eventDateTime) throws IngestExternalException {
        String xmlDefault;
        try {
            xmlDefault = FileUtil.readInputStream((InputStream)PropertiesUtils.getResourceAsStream((String)ATR_KO_DEFAULT_XML));
        }
        catch (IOException e) {
            throw new IngestExternalException((Throwable)e);
        }
        Object detail = VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)code);
        if (addedMessage != null) {
            detail = (String)detail + addedMessage;
        }
        String event = VitamLogbookMessages.getLabelOp((String)eventType);
        return xmlDefault.replace(DATE, LocalDateUtil.nowFormatted()).replace(MESSAGE_IDENTIFIER, messageIdentifier).replace(ARCHIVAL_AGENCY, archivalAgency).replace(TRANSFERRING_AGENCY, transferringAgency).replace(COMMENT, (CharSequence)detail).replace(EVENT_TYPE_CODE, eventType).replace(EVENT_TYPE, event).replace(EVENT_DATE_TIME, LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)eventDateTime)).replaceAll(OUTCOME, code.name()).replace(OUTCOME_DETAIL, eventType + "." + code.name()).replace(OUTCOME_DETAIL_MESSAGE, (CharSequence)detail);
    }
}

