/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.core.permission;

import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;

public class VersionUsagePermissionValidator {
    public static final String FORBIDDEN_MESSAGE = "You are not allowed to access this object";

    public void validate(VersionsModel ... items) throws AccessUnauthorizedException {
        AccessContractModel accessContract = VitamThreadUtils.getVitamSession().getContract();
        for (VersionsModel item : items) {
            boolean isAllowed;
            boolean bl = isAllowed = accessContract.isEveryDataObjectVersion() != false || accessContract.getDataObjectVersion().stream().anyMatch(usage -> item.getDataObjectVersion().startsWith((String)usage));
            if (isAllowed) continue;
            throw new AccessUnauthorizedException(FORBIDDEN_MESSAGE);
        }
    }
}

