/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import java.util.List;

public class DslParserHelper {
    public static JsonNode getValueForUpdateDsl(JsonNode query, String fieldName) throws InvalidParseOperationException {
        UpdateParserMultiple updateParserMultiple = new UpdateParserMultiple();
        updateParserMultiple.parse(query);
        List actions = updateParserMultiple.getRequest().getActions();
        JsonNode result = null;
        for (Action action : actions) {
            ObjectNode currentAction = action.getCurrentAction();
            JsonNode setAction = currentAction.get(BuilderToken.UPDATEACTION.SET.exactToken());
            JsonNode value = DslParserHelper.getValueForSetAction(setAction, fieldName);
            if (value == null) continue;
            result = value;
        }
        return result;
    }

    private static JsonNode getValueForSetAction(JsonNode setAction, String key) {
        if (setAction == null) {
            return null;
        }
        String[] keyParts = key.split("\\.");
        for (int i = 0; i < keyParts.length; ++i) {
            String partialKey = DslParserHelper.getPartialKeys(keyParts, i);
            JsonNode value = setAction.get(partialKey);
            for (int j = i + 1; j < keyParts.length; ++j) {
                value = DslParserHelper.getSubValue(value, keyParts[j]);
            }
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static JsonNode getSubValue(JsonNode node, String subKey) {
        if (node == null) {
            return null;
        }
        return node.get(subKey);
    }

    private static String getPartialKeys(String[] fieldNameParts, int nbComponents) {
        StringBuilder partialFieldName = new StringBuilder(fieldNameParts[0]);
        for (int i = 1; i <= nbComponents; ++i) {
            partialFieldName.append(".").append(fieldNameParts[i]);
        }
        return partialFieldName.toString();
    }
}

