/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.model;

import fr.gouv.vitam.common.ParametersChecker;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class MergeSortedIterator<A, E>
implements Iterator<E> {
    private PeekingIterator<A> one;
    private PeekingIterator<A> two;
    private BiFunction<A, A, E> mergeFunction;
    private Comparator<A> comparator;

    public MergeSortedIterator(Iterator<A> one, Iterator<A> two, Comparator<A> comparator, BiFunction<A, A, E> mergeFunction) {
        ParametersChecker.checkParameter((String)"All params are required", (Object[])new Object[]{one, two, comparator, mergeFunction});
        this.one = PeekingIterator.peekingIterator(one);
        this.two = PeekingIterator.peekingIterator(two);
        this.mergeFunction = mergeFunction;
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        return this.one.hasNext() || this.two.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int compare = this.comparator.compare(this.one.peek(), this.two.peek());
        if (compare == 0) {
            return this.mergeFunction.apply(this.one.next(), this.two.next());
        }
        if (compare > 0) {
            return this.mergeFunction.apply(this.one.next(), null);
        }
        return this.mergeFunction.apply(null, this.two.next());
    }
}

