/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import fr.gouv.vitam.batch.report.model.AuditFullStatusCount;
import fr.gouv.vitam.batch.report.model.AuditObjectGroupModel;
import fr.gouv.vitam.batch.report.model.AuditStatsModel;
import fr.gouv.vitam.batch.report.model.AuditStatusCount;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AuditReportRepository
extends ReportCommonRepository {
    public static final String AUDIT_OBJECT_GROUP = "AuditObjectGroup";
    private final MongoCollection<Document> objectGroupReportCollection;

    @VisibleForTesting
    public AuditReportRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.objectGroupReportCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public AuditReportRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, AUDIT_OBJECT_GROUP);
    }

    public void bulkAppendReport(List<AuditObjectGroupModel> reports) {
        HashSet<AuditObjectGroupModel> reportsWithoutDuplicate = new HashSet<AuditObjectGroupModel>(reports);
        List<Document> auditObjectGroupDocument = reportsWithoutDuplicate.stream().map(ReportCommonRepository::pojoToDocument).collect(Collectors.toList());
        super.bulkAppendReport(auditObjectGroupDocument, this.objectGroupReportCollection);
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.objectGroupReportCollection);
    }

    public ReportResults computeVitamResults(String processId, Integer tenantId) {
        ReportResults reportResult = new ReportResults(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        Bson groupOnSp = Aggregates.group((Object)"$_metadata.status", (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        MongoCursor<Document> objectGroupsStatusCountResult = this.getListStats(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant})), groupOnSp);
        while (objectGroupsStatusCountResult.hasNext()) {
            Document result = (Document)objectGroupsStatusCountResult.next();
            String status = result.getString((Object)"_id");
            Integer count = result.getInteger((Object)"result");
            switch (status) {
                case "OK": {
                    reportResult.setNbOk(count);
                    break;
                }
                case "WARNING": {
                    reportResult.setNbWarning(count);
                    break;
                }
                case "KO": {
                    reportResult.setNbKo(count);
                    break;
                }
            }
        }
        return reportResult;
    }

    public MongoCursor<Document> findCollectionByProcessIdTenantAndStatus(String processId, int tenantId, String ... status) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        Bson inStatus = Filters.or((Bson[])new Bson[]{Filters.in((String)"_metadata.status", (Object[])status), Filters.in((String)"_metadata.objectVersions.status", (Object[])status)});
        return this.objectGroupReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant, inStatus})), Aggregates.project((Bson)this.reportProjection()))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        return this.objectGroupReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant})), Aggregates.project((Bson)this.reportProjection()))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public AuditStatsModel stats(String processId, int tenantId) {
        Bson eqProcessId = Filters.eq((String)"processId", (Object)processId);
        Bson eqTenant = Filters.eq((String)"_tenant", (Object)tenantId);
        Bson filterAgg = this.getMatchAggregation(Filters.and((Bson[])new Bson[]{eqProcessId, eqTenant}));
        int nbObjectGroups = this.getNbObjectGroups(filterAgg);
        int nbObjects = this.getNbObjects(filterAgg);
        Set<String> opis = this.getObjectsOpi(filterAgg);
        AuditFullStatusCount globalResults = new AuditFullStatusCount(new AuditStatusCount(), new AuditStatusCount());
        this.getNbGotsStatus(filterAgg, globalResults);
        this.getNbObjectsStatus(filterAgg, globalResults);
        HashMap<String, AuditFullStatusCount> originatingAgencyResults = new HashMap<String, AuditFullStatusCount>();
        this.getNbGotsStatusBySp(filterAgg, originatingAgencyResults);
        this.getNbObjectsStatusBySp(filterAgg, originatingAgencyResults);
        return new AuditStatsModel(nbObjectGroups, nbObjects, opis, globalResults, originatingAgencyResults);
    }

    private int getNbObjectGroups(Bson matchAgg) {
        Document nbObjectGroupsResult = this.getStats(matchAgg, this.getGroupAggregation("nbObjectGroups"));
        if (nbObjectGroupsResult != null) {
            return nbObjectGroupsResult.getInteger((Object)"result");
        }
        return 0;
    }

    private int getNbObjects(Bson matchAgg) {
        Document nbObjectsResult = this.getStats(matchAgg, this.getUnwindAggregation("_metadata.objectVersions"), this.getGroupAggregation("nbObjects"));
        if (nbObjectsResult != null) {
            return nbObjectsResult.getInteger((Object)"result");
        }
        return 0;
    }

    private Set<String> getObjectsOpi(Bson matchAgg) {
        Bson unwindVersions = Aggregates.unwind((String)"$_metadata.objectVersions");
        Bson groupObjectOpi = Aggregates.group((Object)"$_metadata.objectVersions.opi", (BsonField[])new BsonField[0]);
        Bson projectObjectOpi = Aggregates.project((Bson)new Document("_id", (Object)"$_id"));
        HashSet<String> opis = new HashSet<String>();
        MongoCursor<Document> opisResult = this.getListStats(matchAgg, unwindVersions, groupObjectOpi, projectObjectOpi);
        while (opisResult.hasNext()) {
            Document opi = (Document)opisResult.next();
            opis.add(opi.getString((Object)"_id"));
        }
        return opis;
    }

    private void getNbGotsStatus(Bson matchAgg, AuditFullStatusCount results) {
        Bson groupOnSp = Aggregates.group((Object)"$_metadata.status", (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        MongoCursor<Document> objectGroupsStatusCountResult = this.getListStats(matchAgg, groupOnSp);
        while (objectGroupsStatusCountResult.hasNext()) {
            Document result = (Document)objectGroupsStatusCountResult.next();
            String status = result.getString((Object)"_id");
            Integer count = result.getInteger((Object)"result");
            results.getObjectGroupsCount().addOneStatus(status, count.intValue());
        }
    }

    private void getNbObjectsStatus(Bson matchAgg, AuditFullStatusCount results) {
        Bson unwindVersions = Aggregates.unwind((String)"$_metadata.objectVersions");
        Bson groupOnSp = Aggregates.group((Object)"$_metadata.objectVersions.status", (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        MongoCursor<Document> objectGroupsStatusCountResult = this.getListStats(matchAgg, unwindVersions, groupOnSp);
        while (objectGroupsStatusCountResult.hasNext()) {
            Document result = (Document)objectGroupsStatusCountResult.next();
            String status = result.getString((Object)"_id");
            Integer count = result.getInteger((Object)"result");
            results.getObjectsCount().addOneStatus(status, count.intValue());
        }
    }

    private void getNbGotsStatusBySp(Bson matchAgg, Map<String, AuditFullStatusCount> results) {
        HashMap<String, String> groupId = new HashMap<String, String>();
        groupId.put("originatingAgency", "$_metadata.originatingAgency");
        groupId.put("status", "$_metadata.status");
        BasicDBObject groupFields = new BasicDBObject(groupId);
        Bson groupOnSp = Aggregates.group((Object)groupFields, (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        MongoCursor<Document> objectGroupsStatusCountResult = this.getListStats(matchAgg, groupOnSp);
        while (objectGroupsStatusCountResult.hasNext()) {
            Document result = (Document)objectGroupsStatusCountResult.next();
            Document id = (Document)result.get((Object)"_id", Document.class);
            String originatingAgency = id.getString((Object)"originatingAgency");
            String status = id.getString((Object)"status");
            Integer count = result.getInteger((Object)"result");
            if (!results.containsKey(originatingAgency)) {
                results.put(originatingAgency, new AuditFullStatusCount(new AuditStatusCount(), new AuditStatusCount()));
            }
            results.get(originatingAgency).getObjectGroupsCount().addOneStatus(status, count.intValue());
        }
    }

    private void getNbObjectsStatusBySp(Bson matchAgg, Map<String, AuditFullStatusCount> results) {
        Bson unwindVersions = Aggregates.unwind((String)"$_metadata.objectVersions");
        HashMap<String, String> groupId = new HashMap<String, String>();
        groupId.put("originatingAgency", "$_metadata.originatingAgency");
        groupId.put("status", "$_metadata.objectVersions.status");
        BasicDBObject groupFields = new BasicDBObject(groupId);
        Bson groupOnSp = Aggregates.group((Object)groupFields, (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
        MongoCursor<Document> objectGroupsStatusCountResult = this.getListStats(matchAgg, unwindVersions, groupOnSp);
        while (objectGroupsStatusCountResult.hasNext()) {
            Document result = (Document)objectGroupsStatusCountResult.next();
            Document id = (Document)result.get((Object)"_id", Document.class);
            String originatingAgency = id.getString((Object)"originatingAgency");
            String status = id.getString((Object)"status");
            Integer count = result.getInteger((Object)"result");
            if (!results.containsKey(originatingAgency)) {
                results.put(originatingAgency, new AuditFullStatusCount(new AuditStatusCount(), new AuditStatusCount()));
            }
            results.get(originatingAgency).getObjectsCount().addOneStatus(status, count.intValue());
        }
    }

    private Bson reportProjection() {
        return Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("outcome", (Object)"$_metadata.outcome"), new Document("detailType", (Object)"$_metadata.detailType"), new Document("detailId", (Object)"$_metadata.detailId"), new Document("params.id", (Object)"$_metadata.id"), new Document("params.status", (Object)"$_metadata.status"), new Document("params.opi", (Object)"$_metadata.opi"), new Document("params.originatingAgency", (Object)"$_metadata.originatingAgency"), new Document("params.parentUnitIds", (Object)"$_metadata.parentUnitIds"), new Document("params.objectVersions", (Object)"$_metadata.objectVersions")});
    }

    private Bson getMatchAggregation(Bson filter) {
        return Aggregates.match((Bson)filter);
    }

    private Bson getUnwindAggregation(String field) {
        return Aggregates.unwind((String)String.format("$%s", field));
    }

    private Bson getGroupAggregation(String name) {
        return Aggregates.group((Object)String.format("$%s", name), (BsonField[])new BsonField[]{Accumulators.sum((String)"result", (Object)1)});
    }

    private MongoCursor<Document> getListStats(Bson ... aggregations) {
        return this.objectGroupReportCollection.aggregate(Arrays.asList(aggregations)).iterator();
    }

    private Document getStats(Bson ... aggregations) {
        return (Document)this.objectGroupReportCollection.aggregate(Arrays.asList(aggregations)).first();
    }
}

