/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.timestamp;

import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.TimeStampException;
import fr.gouv.vitam.common.timestamp.TimeStampSignature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;

public class TimestampGenerator {
    private final TimeStampSignature timeStampSignature;

    public TimestampGenerator(TimeStampSignature timeStampSignature) {
        this.timeStampSignature = timeStampSignature;
    }

    public byte[] generateToken(byte[] hash, DigestType digestType, BigInteger nonce) throws TimeStampException {
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(true);
        TimeStampRequest request = reqGen.generate(this.digestToOid(digestType), hash, nonce);
        try {
            TimeStampResponse timeStampResponse = this.timeStampSignature.sign(request);
            timeStampResponse.validate(request);
            return timeStampResponse.getEncoded();
        }
        catch (IOException | CertificateEncodingException | OperatorCreationException | TSPException e) {
            throw new TimeStampException("unable to generate timestamp token", e);
        }
    }

    private ASN1ObjectIdentifier digestToOid(DigestType digestType) {
        switch (digestType) {
            case MD5: {
                return PKCSObjectIdentifiers.md5;
            }
            case SHA1: {
                return OIWObjectIdentifiers.idSHA1;
            }
            case SHA256: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case SHA384: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case SHA512: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException(String.format("digestType: %s has no oid value", digestType));
    }
}

