/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class LazySequenceInputStream
extends InputStream {
    private final Iterator<InputStream> inputStreamIterator;
    private InputStream currentInputStream = null;
    private boolean isClosed = false;

    public LazySequenceInputStream(Iterator<InputStream> lazyInputStreamIterator) {
        this.inputStreamIterator = lazyInputStreamIterator;
    }

    @Override
    public int read() throws IOException {
        this.ensureNotClosed();
        while (this.loadNextInputStreamIfNeeded()) {
            int read = this.currentInputStream.read();
            if (read != -1) {
                return read;
            }
            this.closeCurrentInputStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.ensureNotClosed();
        while (this.loadNextInputStreamIfNeeded()) {
            int read = this.currentInputStream.read(b);
            if (read != -1) {
                return read;
            }
            this.closeCurrentInputStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureNotClosed();
        while (this.loadNextInputStreamIfNeeded()) {
            int read = this.currentInputStream.read(b, off, len);
            if (read != -1) {
                return read;
            }
            this.closeCurrentInputStream();
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.closeCurrentInputStream();
        this.isClosed = true;
    }

    private void closeCurrentInputStream() throws IOException {
        if (this.currentInputStream != null) {
            this.currentInputStream.close();
            this.currentInputStream = null;
        }
    }

    private boolean loadNextInputStreamIfNeeded() {
        if (this.currentInputStream != null) {
            return true;
        }
        if (!this.inputStreamIterator.hasNext()) {
            return false;
        }
        this.currentInputStream = this.inputStreamIterator.next();
        if (this.currentInputStream == null) {
            throw new IllegalStateException("Null input stream");
        }
        return true;
    }

    private void ensureNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Attempted read from closed stream");
        }
    }
}

