/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.stream.ProducerConsumerLock;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class BoundedByteBuffer
implements AutoCloseable {
    private final int bufferSize;
    private final byte[] circularBuffer;
    private final ProducerConsumerLock[] locks;
    private final int readerCount;
    private AtomicBoolean endOfStream = new AtomicBoolean(false);
    private final Writer writer;
    private final Reader[] readers;

    public BoundedByteBuffer(int bufferSize, int readerCount) {
        int i;
        this.bufferSize = bufferSize;
        this.readerCount = readerCount;
        this.circularBuffer = new byte[bufferSize];
        this.locks = new ProducerConsumerLock[readerCount];
        for (i = 0; i < readerCount; ++i) {
            this.locks[i] = new ProducerConsumerLock(bufferSize);
        }
        this.writer = new Writer();
        this.readers = new Reader[readerCount];
        for (i = 0; i < readerCount; ++i) {
            this.readers[i] = new Reader(i);
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public InputStream getReader(int index) {
        if (index < 0 || index >= this.readerCount) {
            throw new IllegalArgumentException("Invalid index");
        }
        return this.readers[index];
    }

    @Override
    public void close() {
        this.writer.close();
        for (Reader reader : this.readers) {
            reader.close();
        }
    }

    private class Reader
    extends InputStream
    implements AutoCloseable {
        private final ProducerConsumerLock lock;
        private int readPos;
        private boolean closed;

        private Reader(int index) {
            if (index < 0 || index >= BoundedByteBuffer.this.readerCount) {
                throw new IllegalArgumentException("Invalid index");
            }
            this.readPos = 0;
            this.lock = BoundedByteBuffer.this.locks[index];
            this.closed = false;
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int res = this.read(buffer, 0, 1);
            if (res == -1) {
                return -1;
            }
            return buffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (offset < 0 || length < 0 || offset + length > buffer.length) {
                throw new IllegalArgumentException("Invalid length");
            }
            if (this.closed) {
                throw new IOException("Cannot read from closed buffer");
            }
            if (length == 0) {
                return 0;
            }
            int availableLength = this.awaitDataAvailableToRead(length);
            if (availableLength == 0) {
                if (BoundedByteBuffer.this.endOfStream.get()) {
                    return -1;
                }
                throw new IOException("Broken stream. Buffer closed without EOF");
            }
            int bytesToReadFromPos = Math.min(BoundedByteBuffer.this.bufferSize - this.readPos, availableLength);
            System.arraycopy(BoundedByteBuffer.this.circularBuffer, this.readPos, buffer, offset, bytesToReadFromPos);
            int bytesToReadFromBeginning = availableLength - bytesToReadFromPos;
            if (bytesToReadFromBeginning > 0) {
                System.arraycopy(BoundedByteBuffer.this.circularBuffer, 0, buffer, offset + bytesToReadFromPos, bytesToReadFromBeginning);
            }
            this.readPos = (this.readPos + availableLength) % BoundedByteBuffer.this.bufferSize;
            this.notifyWriter(availableLength);
            return availableLength;
        }

        private int awaitDataAvailableToRead(int length) throws IOException {
            int availableLength;
            try {
                availableLength = this.lock.tryBeginConsume(length);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted thread", e);
            }
            return availableLength;
        }

        private void notifyWriter(int availableLength) {
            this.lock.endConsume(availableLength);
        }

        @Override
        public void close() {
            this.closed = true;
            this.lock.close();
        }
    }

    public class Writer
    implements AutoCloseable {
        private int writePos = 0;
        private boolean closed = false;

        private Writer() {
        }

        public void write(byte[] src, int offset, int length) throws InterruptedException, IOException {
            int bytesToWriteAtBeginning;
            if (offset < 0 || length < 0 || offset + length > src.length || length > BoundedByteBuffer.this.bufferSize) {
                throw new IllegalArgumentException("Invalid offset / length");
            }
            if (this.closed) {
                throw new IOException("Cannot write to closed buffer");
            }
            this.awaitFreeBufferSpace(length);
            int bytesToWriteAtEnd = Math.min(BoundedByteBuffer.this.bufferSize - this.writePos, length);
            if (bytesToWriteAtEnd > 0) {
                System.arraycopy(src, offset, BoundedByteBuffer.this.circularBuffer, this.writePos, bytesToWriteAtEnd);
            }
            if ((bytesToWriteAtBeginning = length - bytesToWriteAtEnd) > 0) {
                System.arraycopy(src, offset + bytesToWriteAtEnd, BoundedByteBuffer.this.circularBuffer, 0, bytesToWriteAtBeginning);
            }
            this.writePos = (this.writePos + length) % BoundedByteBuffer.this.bufferSize;
            this.notifyConsumers(length);
        }

        private void awaitFreeBufferSpace(int length) throws InterruptedException, IOException {
            boolean atLeastOneReaderAlive = false;
            for (ProducerConsumerLock lock : BoundedByteBuffer.this.locks) {
                boolean acquired = lock.tryBeginProduce(length);
                if (!acquired) continue;
                atLeastOneReaderAlive = true;
            }
            if (!atLeastOneReaderAlive) {
                throw new IOException("Broken stream. No more active readers");
            }
        }

        private void notifyConsumers(int length) {
            for (ProducerConsumerLock lock : BoundedByteBuffer.this.locks) {
                lock.endProduce(length);
            }
        }

        public void writeEOF() {
            BoundedByteBuffer.this.endOfStream.set(true);
        }

        @Override
        public void close() {
            this.closed = true;
            for (ProducerConsumerLock lock : BoundedByteBuffer.this.locks) {
                lock.close();
            }
        }
    }
}

