/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application.resources;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class VersionHelper {
    private static final VitamLogger LOGGER;
    private static final List<Map<String, String>> cachedComponents;
    private static final String MANIFEST_VITAM_FLAG = "Vitam-component";
    public static final String MANIFEST_SUMMARY_TAG = "Scm-commit-id";
    public static final List<String> MANIFEST_FIELDS;

    public static List<Map<String, String>> getVersionDetailedInfo() {
        return Collections.unmodifiableList(cachedComponents);
    }

    public static Map<String, Long> getVersionSummary() {
        return cachedComponents.stream().collect(Collectors.groupingBy(n -> n.getOrDefault(MANIFEST_SUMMARY_TAG, "<no commit id found>"), Collectors.counting()));
    }

    private static Map<String, String> extractManifestInfo(Manifest mf) {
        HashMap<String, String> result = new HashMap<String, String>();
        Attributes attr = mf.getMainAttributes();
        for (String field : MANIFEST_FIELDS) {
            result.put(field, attr.getValue(field));
        }
        LOGGER.info("Found component : {}", result);
        return Collections.unmodifiableMap(result);
    }

    static {
        AbstractList resources;
        LOGGER = VitamLoggerFactory.getInstance(VersionHelper.class);
        cachedComponents = new ArrayList<Map<String, String>>();
        MANIFEST_FIELDS = Collections.unmodifiableList(Arrays.asList("Maven-groupId", "Maven-artefactId", "Maven-version", "Scm-branch", "Scm-tags", MANIFEST_SUMMARY_TAG, "Scm-commit-id-abbrev", "Scm-dirty", "Scm-commit-time", "Maven-build-timestamp", "Build-Jdk"));
        try {
            resources = Collections.list(Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF"));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to open any MANIFEST.MF during the search of component versions... No component version will be available in status API.", (Throwable)e);
            resources = new LinkedList();
        }
        if (resources.isEmpty()) {
            LOGGER.warn("No MANIFEST.MF file was found ! No component version will be available in status API");
        } else {
            LOGGER.info("Found {} components in classpath.", (Object)resources.size());
        }
        for (URL resource : resources) {
            try {
                Manifest manifest = new Manifest(resource.openStream());
                if (manifest.getMainAttributes().getValue(MANIFEST_VITAM_FLAG) == null) continue;
                cachedComponents.add(VersionHelper.extractManifestInfo(manifest));
            }
            catch (Exception e) {
                LOGGER.warn("Unable to open MANIFEST.MF (from " + resource + ") to search for the component version... Skipping component.", (Throwable)e);
            }
        }
    }
}

