/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application;

import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.stream.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import javax.ws.rs.core.StreamingOutput;

public class VitamStreamingOutput
implements StreamingOutput,
VitamAutoCloseable {
    private InputStream inputStream;
    private final File file;
    private final boolean toDelete;

    public VitamStreamingOutput(InputStream inputStream) {
        this.inputStream = inputStream;
        this.file = null;
        this.toDelete = false;
    }

    public VitamStreamingOutput(File file, boolean toDelete) {
        this.file = file;
        this.toDelete = toDelete;
        this.inputStream = null;
    }

    public void write(OutputStream output) throws IOException {
        if (this.inputStream == null && this.file != null) {
            this.inputStream = new FileInputStream(this.file);
        }
        if (this.inputStream != null) {
            try (InputStream entityStream = this.inputStream;){
                StreamUtils.copy((InputStream)entityStream, (OutputStream)output);
            }
        }
        if (this.file != null && this.toDelete) {
            Files.delete(this.file.toPath());
        }
    }

    public void close() {
        if (this.inputStream != null) {
            StreamUtils.closeSilently((InputStream)this.inputStream);
        }
    }
}

