/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.waf;

import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.SanityChecker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jboss.resteasy.core.interception.jaxrs.PostMatchContainerRequestContext;

@Priority(value=2000)
public class SanityCheckerJsonFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SanityCheckerJsonFilter.class);
    private static final String CHECK_SANITY = "CHECK_SANITY";
    private static final String CODE_VITAM = "code_vitam";
    private static final AlertService alertService = new AlertServiceImpl();

    public void filter(ContainerRequestContext requestContext) throws IOException {
        InputStream bodyInputStream = requestContext.getEntityStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bodyInputStream.transferTo((OutputStream)bout);
        try {
            SanityChecker.checkJsonAll(JsonHandler.getFromInputStream((InputStream)bout.toInputStream()));
            requestContext.setEntityStream(bout.toInputStream());
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            if (Arrays.asList(((PostMatchContainerRequestContext)requestContext).getResourceMethod().getProduces()).contains(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
            } else {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorEntity(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build());
            }
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.error((Throwable)exc);
            alertService.createAlert("Json invalid: " + exc.getMessage());
            if (Arrays.asList(((PostMatchContainerRequestContext)requestContext).getResourceMethod().getProduces()).contains(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
            }
            requestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorEntity(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build());
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(CHECK_SANITY).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

