/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.merkletree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.security.merkletree.MerkleTree;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MerkleTreeAlgo {
    private final DigestType digestType;
    private List<MerkleTree> leaves = new ArrayList<MerkleTree>();

    public MerkleTreeAlgo(DigestType digestType) {
        this.digestType = digestType;
    }

    @VisibleForTesting
    void addLeaf(String str) {
        this.addLeaf(str.getBytes(StandardCharsets.UTF_8));
    }

    public void addLeaf(byte[] data) {
        Digest digest = new Digest(this.digestType);
        MerkleTree tree = new MerkleTree(digest.update(data).digest(), null, null);
        this.leaves.add(tree);
    }

    @VisibleForTesting
    int numberOfLeaves() {
        return this.leaves.size();
    }

    private byte[] concat(byte[] left, byte[] right) {
        Digest digest = new Digest(this.digestType);
        digest.update(left);
        digest.update(right);
        return digest.digest();
    }

    @VisibleForTesting
    void addPadding() {
        int numberOfLeaf = this.leaves.size();
        if (Long.bitCount(numberOfLeaf) == 1) {
            return;
        }
        long l = Long.highestOneBit(2 * numberOfLeaf);
        int j = 0;
        while ((long)j < l - (long)numberOfLeaf) {
            this.leaves.add(MerkleTree.EMPTY_LEAF);
            ++j;
        }
    }

    public MerkleTree generateMerkle() {
        this.addPadding();
        MerkleTree tree = (MerkleTree)Iterables.getFirst(this.leaves, null);
        while (this.leaves.size() > 1) {
            ArrayList<MerkleTree> nextList = new ArrayList<MerkleTree>();
            for (int i = 0; i < this.leaves.size(); i += 2) {
                byte[] hash = this.concat(this.leaves.get(i).getRoot(), this.leaves.get(i + 1).getRoot());
                tree = new MerkleTree(hash, this.leaves.get(i), this.leaves.get(i + 1));
                nextList.add(tree);
            }
            this.leaves = nextList;
        }
        return tree;
    }
}

