/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.mapper;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementMapper {
    private ElementMapper() {
    }

    public static Map<String, Object> toMap(List<Object> elements) {
        Map<String, Object> collect = elements.stream().filter(item -> item instanceof Element).map(item -> (Element)item).map(item -> new AbstractMap.SimpleImmutableEntry<String, List<Object>>(item.getLocalName(), ElementMapper.elementToMap(item))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue, (o, o2) -> Stream.concat(o.stream(), o2.stream()).collect(Collectors.toList())));
        return collect;
    }

    private static List<Object> elementToMap(Element item) {
        NodeList childNodes = item.getChildNodes();
        ArrayListMultimap objectObjectHashMap = ArrayListMultimap.create();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1) {
                objectObjectHashMap.put((Object)child.getLocalName(), (Object)child);
                continue;
            }
            if (child.getNodeType() != 3 || Strings.isNullOrEmpty((String)child.getTextContent().trim())) continue;
            return Collections.singletonList(child.getTextContent());
        }
        HashMap maps = new HashMap();
        for (String s : objectObjectHashMap.keySet()) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Node child : objectObjectHashMap.get((Object)s)) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        if (child.hasChildNodes() && child.getChildNodes().getLength() >= 1) {
                            objects.addAll(ElementMapper.elementToMap((Element)child));
                            break;
                        }
                        String textContent = child.getTextContent();
                        if (textContent.isEmpty()) break;
                        objects.add(textContent);
                    }
                }
            }
            maps.put(s, objects);
        }
        if (maps.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(maps);
    }
}

