/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.graph;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.graph.NodeIterable;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class DirectedGraph {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DirectedGraph.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private final int vertices;
    private final NodeIterable<Integer>[] adj;
    private final int[] indegree;
    BidiMap<Integer, String> indexMapping;
    int count = 0;

    private DirectedGraph(int vertices) {
        if (vertices < 0) {
            throw new IllegalArgumentException("Number of vertices in a DirectedGraph must be nonnegative");
        }
        this.vertices = vertices;
        this.indegree = new int[vertices];
        this.adj = new NodeIterable[vertices];
        for (int v = 0; v < vertices; ++v) {
            this.adj[v] = new NodeIterable();
        }
    }

    public DirectedGraph(JsonNode jsonGraph) {
        this.indexMapping = new DualHashBidiMap();
        this.vertices = jsonGraph.size() + 1;
        this.adj = new NodeIterable[this.vertices];
        for (int v = 0; v < this.vertices; ++v) {
            this.adj[v] = new NodeIterable();
        }
        this.indegree = new int[this.vertices];
        Iterator iterator2 = jsonGraph.fields();
        while (iterator2.hasNext()) {
            Map.Entry cycle = (Map.Entry)iterator2.next();
            String idChild = (String)cycle.getKey();
            JsonNode up = (JsonNode)cycle.getValue();
            this.addMapIdToIndex(idChild);
            if (up == null || up.size() <= 0) continue;
            JsonNode arrNode = up.get("_up");
            for (JsonNode idParent : arrNode) {
                this.addEdge(this.getIndex(idParent.textValue()), this.getIndex(idChild));
                LOGGER.debug("source:" + idParent);
                LOGGER.debug("destin:" + idChild);
            }
        }
    }

    public int getVertices() {
        return this.vertices;
    }

    private void validateVertex(int v) {
        if (v < 0 || v >= this.vertices) {
            throw new IndexOutOfBoundsException("vertex " + v + " is not between 0 and " + (this.vertices - 1));
        }
    }

    private void addEdge(int v, int w) {
        this.validateVertex(v);
        this.validateVertex(w);
        this.adj[v].add(w);
        int n = w;
        this.indegree[n] = this.indegree[n] + 1;
    }

    Iterable<Integer> adj(int v) {
        this.validateVertex(v);
        return this.adj[v];
    }

    public int indegree(int vertices) {
        this.validateVertex(vertices);
        return this.indegree[vertices];
    }

    public DirectedGraph reverse() {
        DirectedGraph reverse = new DirectedGraph(this.vertices);
        for (int v = 0; v < this.vertices; ++v) {
            for (int w : this.adj(v)) {
                reverse.addEdge(w, v);
            }
        }
        return reverse;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.vertices + " vertices,  " + NEWLINE);
        for (int v = 0; v < this.vertices; ++v) {
            s.append(String.format("%d: ", v));
            for (int w : this.adj[v]) {
                s.append(String.format("%d ", w));
            }
            s.append(NEWLINE);
        }
        return s.toString();
    }

    private int getIndex(String id) {
        int key = 0;
        if (this.indexMapping != null) {
            if (this.indexMapping.containsValue((Object)id)) {
                BidiMap xmlIdToIndex = this.indexMapping.inverseBidiMap();
                key = (Integer)xmlIdToIndex.get((Object)id);
            } else {
                key = this.addMapIdToIndex(id);
            }
            return key;
        }
        return key;
    }

    private int addMapIdToIndex(String idXml) {
        BidiMap xmlIdToIndex;
        if (this.indexMapping != null && (xmlIdToIndex = this.indexMapping.inverseBidiMap()).get((Object)idXml) == null) {
            ++this.count;
            this.indexMapping.put((Object)this.count, (Object)idXml);
        }
        return this.count;
    }

    public String getId(Integer index) {
        return (String)this.indexMapping.get((Object)index);
    }
}

