/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.external.client.DefaultClient;
import fr.gouv.vitam.common.external.client.IngestCollection;
import fr.gouv.vitam.common.model.LocalFile;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalClientNotFoundException;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalClientServerException;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientFactory;
import fr.gouv.vitam.ingest.external.client.IngestRequestParameters;
import java.io.InputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

class IngestExternalClientRest
extends DefaultClient
implements IngestExternalClient {
    private static final String INGEST_EXTERNAL_MODULE = "IngestExternalModule";
    private static final String INGEST_URL = "/ingests";
    private static final String BLANK_OBJECT_ID = "object identifier should be filled";
    private static final String BLANK_TYPE = "Type should be filled";

    IngestExternalClientRest(IngestExternalClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public RequestResponse<Void> ingest(VitamContext vitamContext, InputStream stream, String contextId, String action) throws IngestExternalException {
        return this.ingest(vitamContext, stream, new IngestRequestParameters(contextId, action));
    }

    @Override
    public RequestResponse<Void> ingest(VitamContext vitamContext, InputStream stream, IngestRequestParameters ingestRequestParameters) throws IngestExternalException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"Tenant identifier is a mandatory parameter", (Object[])new Object[]{vitamContext.getTenantId()});
            MultivaluedMap headers = vitamContext.getHeaders();
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(INGEST_URL).withHeaders(vitamContext.getHeaders()).withHeader("X-Context-Id", (Object)ingestRequestParameters.getContextId()).withHeader("X-ACTION", (Object)ingestRequestParameters.getAction()).withHeaderIgnoreNull("X-Manifest-Digest-Algo", (Object)ingestRequestParameters.getManifestDigestAlgo()).withHeaderIgnoreNull("X-Manifest-Digest-Value", (Object)ingestRequestParameters.getManifestDigestValue()).withHeader("Expect", (Object)"100-continue").withBody((Object)stream, "Stream is a mandatory parameter").withOctetContentType().withXMLAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().parseHeadersFromResponse(response).setHttpCode(response.getStatus());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IngestExternalClientServerException vitamError) {
                    return vitamError.getVitamError();
                }
                catch (VitamClientInternalException | IngestExternalClientNotFoundException e) {
                    throw new IngestExternalException("Ingest External Internal Server Error", e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response downloadObjectAsync(VitamContext vitamContext, String objectId, IngestCollection type) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_OBJECT_ID, (String[])new String[]{objectId});
        ParametersChecker.checkParameter((String)BLANK_TYPE, (Object[])new Object[]{type});
        Response response = null;
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/ingests/" + objectId + "/" + type.getCollectionName()).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        catch (IngestExternalClientServerException | IngestExternalException e) {
            throw new VitamClientException(e);
        }
        catch (IngestExternalClientNotFoundException e) {
            Response response3 = response;
            return response3;
        }
        finally {
            if (response != null && Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily() && Response.Status.NOT_FOUND.getStatusCode() != response.getStatus()) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse<Void> ingestLocal(VitamContext vitamContext, LocalFile localFile, String contextId, String action) throws IngestExternalException {
        return this.ingestLocal(vitamContext, localFile, new IngestRequestParameters(contextId, action));
    }

    @Override
    public RequestResponse<Void> ingestLocal(VitamContext vitamContext, LocalFile localFile, IngestRequestParameters ingestRequestParameters) throws IngestExternalException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"Tenant identifier is a mandatory parameter", (Object[])new Object[]{vitamContext.getTenantId()});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(INGEST_URL).withHeaders(vitamContext.getHeaders()).withHeader("X-Context-Id", (Object)ingestRequestParameters.getContextId()).withHeader("X-ACTION", (Object)ingestRequestParameters.getAction()).withHeaderIgnoreNull("X-Manifest-Digest-Algo", (Object)ingestRequestParameters.getManifestDigestAlgo()).withHeaderIgnoreNull("X-Manifest-Digest-Value", (Object)ingestRequestParameters.getManifestDigestValue()).withHeader("Expect", (Object)"100-continue").withBody((Object)localFile, "localFile is a mandatory parameter").withJsonContentType().withXMLAccept();
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = new RequestResponseOK().parseHeadersFromResponse(response).setHttpCode(response.getStatus());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IngestExternalClientServerException vitamError) {
                    return vitamError.getVitamError();
                }
                catch (VitamClientInternalException | IngestExternalClientNotFoundException e) {
                    throw new IngestExternalException("Ingest External Internal Server Error", e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    private void check(Response response) throws IngestExternalException, IngestExternalClientServerException, IngestExternalClientNotFoundException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case BAD_REQUEST: 
            case PARTIAL_CONTENT: 
            case INTERNAL_SERVER_ERROR: {
                VitamError vitamError = new VitamError(VitamCode.INGEST_EXTERNAL_UPLOAD_ERROR.getItem()).setHttpCode(status.getStatusCode()).setDescription(VitamCode.INGEST_EXTERNAL_UPLOAD_ERROR.getMessage() + " Cause : " + status.getReasonPhrase()).setMessage(VitamCode.INGEST_EXTERNAL_UPLOAD_ERROR.getMessage()).setState(StatusCode.KO.name()).setContext(INGEST_EXTERNAL_MODULE);
                throw new IngestExternalClientServerException(vitamError);
            }
            case SERVICE_UNAVAILABLE: {
                VitamError vitamErrorFatal = new VitamError(VitamCode.INGEST_EXTERNAL_UPLOAD_ERROR.getItem()).setHttpCode(status.getStatusCode()).setDescription(VitamCode.INGEST_EXTERNAL_UPLOAD_ERROR.getMessage() + " Cause : " + status.getReasonPhrase()).setMessage(VitamCode.INGEST_EXTERNAL_UPLOAD_ERROR.getMessage()).setState(StatusCode.FATAL.name()).setContext(INGEST_EXTERNAL_MODULE);
                throw new IngestExternalClientServerException(vitamErrorFatal);
            }
            case NOT_FOUND: {
                throw new IngestExternalClientNotFoundException("Not Found");
            }
        }
        throw new IngestExternalException(status.getReasonPhrase());
    }
}

