/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.rest;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.IngestCollection;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.format.identification.FormatIdentifierFactory;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.LocalFile;
import fr.gouv.vitam.common.model.LocalFileAction;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.security.rest.Unsecured;
import fr.gouv.vitam.common.server.application.AsyncInputStreamHelper;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.ingest.external.common.config.IngestExternalConfiguration;
import fr.gouv.vitam.ingest.external.core.AtrKoBuilder;
import fr.gouv.vitam.ingest.external.core.IngestExternalImpl;
import fr.gouv.vitam.ingest.external.core.ManifestDigestValidator;
import fr.gouv.vitam.ingest.external.core.PreUploadResume;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClient;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientFactory;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalClientNotFoundException;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalClientServerException;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/ingest-external/v1")
@Tag(name="Ingest")
public class IngestExternalResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestExternalResource.class);
    private final IngestExternalConfiguration ingestExternalConfiguration;
    private final SecureEndpointRegistry secureEndpointRegistry;
    private final FormatIdentifierFactory formatIdentifierFactory;
    private final IngestInternalClientFactory ingestInternalClientFactory;

    public IngestExternalResource(IngestExternalConfiguration ingestExternalConfiguration, SecureEndpointRegistry secureEndpointRegistry, FormatIdentifierFactory formatIdentifierFactory, IngestInternalClientFactory ingestInternalClientFactory) {
        this.ingestExternalConfiguration = ingestExternalConfiguration;
        this.secureEndpointRegistry = secureEndpointRegistry;
        this.formatIdentifierFactory = formatIdentifierFactory;
        this.ingestInternalClientFactory = ingestInternalClientFactory;
        LOGGER.info("init Ingest External Resource server");
    }

    @Path(value="/")
    @OPTIONS
    @Produces(value={"application/json"})
    @Unsecured
    public Response listResourceEndpoints() {
        String resourcePath = IngestExternalResource.class.getAnnotation(Path.class).value();
        List securedEndpointList = this.secureEndpointRegistry.getEndPointsByResourcePath(resourcePath);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)securedEndpointList).build();
    }

    @Path(value="ingests")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.INGESTS_CREATE, description="Envoyer un SIP \u00e0 Vitam afin qu'il en r\u00e9alise l'entr\u00e9e")
    public void upload(@HeaderParam(value="X-Context-Id") String contextId, @HeaderParam(value="X-ACTION") String action, @HeaderParam(value="X-Manifest-Digest-Algo") String manifestDigestAlgo, @HeaderParam(value="X-Manifest-Digest-Value") String manifestDigestValue, InputStream uploadedInputStream, @Suspended AsyncResponse asyncResponse) {
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID guid = GUIDReader.getGUIDUnsafe((String)requestId);
        Integer tenantId = ParameterHelper.getTenantParameter();
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> this.uploadAsync(uploadedInputStream, asyncResponse, tenantId, contextId, action, manifestDigestValue, manifestDigestAlgo, guid, Optional.empty()));
    }

    @Path(value="ingests")
    @POST
    @Consumes(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.INGESTS_LOCAL_CREATE, description="Envoyer un SIP en local \u00e0 Vitam afin qu'il en r\u00e9alise l'entr\u00e9e")
    public void uploadLocal(@HeaderParam(value="X-Context-Id") String contextId, @HeaderParam(value="X-ACTION") String action, @HeaderParam(value="X-Manifest-Digest-Algo") String manifestDigestAlgo, @HeaderParam(value="X-Manifest-Digest-Value") String manifestDigestValue, LocalFile localFile, @Suspended AsyncResponse asyncResponse) {
        java.nio.file.Path path;
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID guid = GUIDReader.getGUIDUnsafe((String)requestId);
        Integer tenantId = ParameterHelper.getTenantParameter();
        try {
            path = SafeFileChecker.checkSafeFilePath((String)this.ingestExternalConfiguration.getBaseUploadPath(), (String[])new String[]{localFile.getPath()}).toPath();
        }
        catch (IllegalPathException e) {
            LOGGER.error("Path traversal check failed", (Throwable)e);
            this.doAsyncResponse(guid, asyncResponse, Response.Status.BAD_REQUEST, VitamCode.INGEST_EXTERNAL_LOCAL_UPLOAD_FILE_SECURITY_ALERT, "Only files in the folder " + this.ingestExternalConfiguration.getBaseUploadPath() + " could be accessed");
            return;
        }
        boolean exists = Files.exists(path, new LinkOption[0]);
        if (!exists) {
            this.doAsyncResponse(guid, asyncResponse, Response.Status.INTERNAL_SERVER_ERROR, VitamCode.INGEST_EXTERNAL_LOCAL_UPLOAD_FILE_HANDLING_ERROR, "File path does not exist.");
        }
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(path.toString()));){
                this.uploadAsync(inputStream, asyncResponse, tenantId, contextId, action, manifestDigestValue, manifestDigestAlgo, guid, Optional.of(path));
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                this.doAsyncResponse(guid, asyncResponse, Response.Status.INTERNAL_SERVER_ERROR, VitamCode.INGEST_EXTERNAL_LOCAL_UPLOAD_FILE_HANDLING_ERROR, e.getLocalizedMessage());
            }
        });
    }

    private void doAsyncResponse(GUID requestId, AsyncResponse asyncResponse, Response.Status status, VitamCode vitamCode, String message) {
        AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)status).header("X-Request-Id", (Object)requestId).header("X-Global-Execution-State", (Object)ProcessState.COMPLETED).header("X-Global-Execution-Status", (Object)StatusCode.FATAL).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)vitamCode, (String)message))).build());
    }

    private void uploadAsync(InputStream uploadedInputStream, AsyncResponse asyncResponse, Integer tenantId, String contextId, String xAction, String manifestDigestValue, String manifestDigestAlgo, GUID operationId, Optional<java.nio.file.Path> localFilePath) {
        IngestExternalImpl ingestExternal = new IngestExternalImpl(this.ingestExternalConfiguration, this.formatIdentifierFactory, this.ingestInternalClientFactory, new ManifestDigestValidator());
        LocalFileAction afterUploadAction = LocalFileAction.getLocalFileAction((String)this.ingestExternalConfiguration.getFileActionAfterUpload().name());
        try {
            PreUploadResume preUploadResume;
            ParametersChecker.checkParameter((String)"HTTP Request must contains stream", (Object[])new Object[]{uploadedInputStream});
            VitamThreadUtils.getVitamSession().setTenantId(tenantId);
            try {
                preUploadResume = ingestExternal.preUploadAndResume(uploadedInputStream, contextId, operationId, xAction, asyncResponse);
            }
            catch (WorkflowNotFoundException ex) {
                LOGGER.error((Throwable)ex);
                String atr = AtrKoBuilder.buildAtrKo((String)operationId.getId(), (String)"ArchivalAgencyToBeDefined", (String)"TransferringAgencyToBeDefined", (String)"STP_UPLOAD_SIP", (String)ex.getMessage(), (StatusCode)StatusCode.KO, (LocalDateTime)LocalDateUtil.now());
                ingestExternal.handleResponseWithATR(operationId, asyncResponse, atr);
                return;
            }
            ingestExternal.upload(preUploadResume, xAction, operationId, manifestDigestValue, manifestDigestAlgo);
            if (localFilePath.isPresent()) {
                java.nio.file.Path path = localFilePath.get();
                switch (afterUploadAction) {
                    case DELETE: {
                        Files.delete(path);
                        break;
                    }
                    case MOVE: {
                        if (this.ingestExternalConfiguration.getSuccessfulUploadDir() == null || this.ingestExternalConfiguration.getSuccessfulUploadDir().isEmpty()) break;
                        Files.move(path, Paths.get(this.ingestExternalConfiguration.getSuccessfulUploadDir(), path.toFile().getName()), StandardCopyOption.REPLACE_EXISTING);
                        break;
                    }
                }
            }
        }
        catch (Exception exc) {
            if (localFilePath.isPresent()) {
                try {
                    if (afterUploadAction.equals((Object)LocalFileAction.MOVE) && this.ingestExternalConfiguration.getFailedUploadDir() != null && !this.ingestExternalConfiguration.getFailedUploadDir().isEmpty()) {
                        java.nio.file.Path path = localFilePath.get();
                        Files.move(path, Paths.get(this.ingestExternalConfiguration.getFailedUploadDir(), path.toFile().getName()), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                    AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Request-Id", (Object)operationId.getId()).header("X-Global-Execution-State", (Object)ProcessState.COMPLETED).header("X-Global-Execution-Status", (Object)StatusCode.FATAL).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_LOCAL_UPLOAD_FILE_HANDLING_ERROR, (String)e.getLocalizedMessage()))).build());
                }
            }
            LOGGER.error((Throwable)exc);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Request-Id", (Object)operationId.getId()).header("X-Global-Execution-State", (Object)ProcessState.COMPLETED).header("X-Global-Execution-Status", (Object)StatusCode.FATAL).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_INTERNAL_SERVER_ERROR, (String)exc.getLocalizedMessage()))).build(), (InputStream)uploadedInputStream);
        }
    }

    @GET
    @Path(value="/ingests/{objectId}/archivetransferreply")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.INGESTS_ID_ARCHIVETRANSFERTREPLY_READ, description="R\u00e9cup\u00e9rer l'accus\u00e9 de r\u00e9c\u00e9ption pour une op\u00e9ration d'entr\u00e9e donn\u00e9e")
    public Response downloadArchiveTransferReplyAsStream(@PathParam(value="objectId") String objectId) {
        return this.downloadObjectAsync(objectId, IngestCollection.REPORTS);
    }

    @GET
    @Path(value="/ingests/{objectId}/manifests")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.INGESTS_ID_MANIFESTS_READ, description="R\u00e9cup\u00e9rer le bordereau de versement pour une op\u00e9ration d'entr\u00e9e donn\u00e9e")
    public Response downloadIngestManifestsAsStream(@PathParam(value="objectId") String objectId) {
        return this.downloadObjectAsync(objectId, IngestCollection.MANIFESTS);
    }

    private Response downloadObjectAsync(String objectId, IngestCollection collection) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block11: {
            IngestInternalClient ingestInternalClient = IngestInternalClientFactory.getInstance().getClient();
            try {
                Response response = ingestInternalClient.downloadObjectAsync(objectId, collection);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response);
                if (ingestInternalClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ingestInternalClient != null) {
                        try {
                            ingestInternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("IllegalArgumentException was thrown : ", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_BAD_REQUEST, (String)e.getLocalizedMessage()))).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("Predicates Failed Exception", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_PRECONDITION_FAILED, (String)e.getLocalizedMessage()))).build();
                }
                catch (IngestInternalClientServerException e) {
                    LOGGER.error("Internal Server Exception ", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage()))).build();
                }
                catch (IngestInternalClientNotFoundException e) {
                    LOGGER.error("Request resources does not exits", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_NOT_FOUND, (String)e.getLocalizedMessage()))).build();
                }
            }
            ingestInternalClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    private InputStream getErrorStream(VitamError vitamError) {
        try {
            return JsonHandler.writeToInpustream((Object)vitamError);
        }
        catch (InvalidParseOperationException e) {
            return new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
    }
}

