/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.ingest.external.common.config.IngestExternalConfiguration;
import fr.gouv.vitam.ingest.external.rest.BusinessApplication;
import javax.ws.rs.core.Application;

public class IngestExternalMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestExternalMain.class);
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.ingest-external.port";
    private static final String CONF_FILE_NAME = "ingest-external.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    private VitamStarter vitamStarter;

    public IngestExternalMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(IngestExternalConfiguration.class, configurationFile, BusinessApplication.class, AdminApplication.class);
    }

    public IngestExternalMain(String configurationFile, Class<? extends Application> testBusinessApplication, Class<? extends Application> testAdminApplication) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        if (null == testBusinessApplication) {
            testBusinessApplication = BusinessApplication.class;
        }
        if (null == testAdminApplication) {
            testAdminApplication = AdminApplication.class;
        }
        this.vitamStarter = new VitamStarter(IngestExternalConfiguration.class, configurationFile, testBusinessApplication, testAdminApplication);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            IngestExternalMain main = new IngestExternalMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            main.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }

    public VitamStarter getVitamStarter() {
        return this.vitamStarter;
    }
}

