/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ingest.external.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.dsl.schema.DslDynamicFeature;
import fr.gouv.vitam.common.format.identification.FormatIdentifierFactory;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.SecureEndpointScanner;
import fr.gouv.vitam.common.security.waf.SanityCheckerCommonFilter;
import fr.gouv.vitam.common.security.waf.SanityDynamicFeature;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.ingest.external.common.config.IngestExternalConfiguration;
import fr.gouv.vitam.ingest.external.rest.IngestExternalResource;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientFactory;
import fr.gouv.vitam.security.internal.filter.AuthorizationFilter;
import fr.gouv.vitam.security.internal.filter.InternalSecurityFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        SecureEndpointRegistry secureEndpointRegistry = new SecureEndpointRegistry();
        SecureEndpointScanner secureEndpointScanner = new SecureEndpointScanner(secureEndpointRegistry);
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            IngestExternalConfiguration configuration = (IngestExternalConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, IngestExternalConfiguration.class);
            this.commonBusinessApplication = new CommonBusinessApplication(true);
            this.singletons = new HashSet<Object>();
            this.singletons.add(new InternalSecurityFilter(configuration.isAllowSslClientHeader()));
            this.singletons.add(new AuthorizationFilter());
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)new IngestExternalResource(configuration, secureEndpointRegistry, FormatIdentifierFactory.getInstance(), IngestInternalClientFactory.getInstance()));
            this.singletons.add(new SanityCheckerCommonFilter());
            this.singletons.add(new SanityDynamicFeature());
            this.singletons.add(secureEndpointScanner);
            this.singletons.add(new DslDynamicFeature());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

