/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.functional.administration.common.ReconstructionItem;
import fr.gouv.vitam.functional.administration.common.ReconstructionRequestItem;
import fr.gouv.vitam.functional.administration.common.ReconstructionResponseItem;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminFactory;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.reconstruction.FunctionalAdministrationReconstructionMetrics;
import fr.gouv.vitam.functional.administration.core.reconstruction.FunctionalAdministrationReconstructionMetricsCache;
import fr.gouv.vitam.functional.administration.core.reconstruction.ReconstructionService;
import fr.gouv.vitam.functional.administration.core.reconstruction.ReconstructionServiceImpl;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class ReconstructionResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReconstructionResource.class);
    private final String RECONSTRUCTION_URI = "/reconstruction";
    private final String ACCESSION_REGISTER_RECONSTRUCTION_URI = "/accessionregisterreconstruction";
    private static final String RECONSTRUCTION_JSON_MONDATORY_PARAMETERS_MSG = "the Json input of reconstruction's parameters is mondatory.";
    private static final String RECONSTRUCTION_COLLECTION_MONDATORY_MSG = "the collection to reconstruct is mondatory.";
    private static final String RECONSTRUCTION_EXCEPTION_MSG = "ERROR: Exception has been thrown when reconstructing Vitam collections: ";
    private final ReconstructionService reconstructionService;
    private final MongoDbAccessAdminImpl mongoAccess;

    public ReconstructionResource(AdminManagementConfiguration configuration, VitamRepositoryProvider reconstructionFactory, OntologyLoader ontologyLoader, ElasticsearchFunctionalAdminIndexManager indexManager) {
        DbConfigurationImpl adminConfiguration = configuration.isDbAuthentication() ? new DbConfigurationImpl(configuration.getMongoDbNodes(), configuration.getDbName(), true, configuration.getDbUserName(), configuration.getDbPassword()) : new DbConfigurationImpl(configuration.getMongoDbNodes(), configuration.getDbName());
        this.mongoAccess = MongoDbAccessAdminFactory.create((DbConfiguration)adminConfiguration, (OntologyLoader)ontologyLoader, (ElasticsearchFunctionalAdminIndexManager)indexManager);
        FunctionalAdministrationReconstructionMetricsCache reconstructionMetricsCache = new FunctionalAdministrationReconstructionMetricsCache((long)configuration.getReconstructionMetricsCacheDurationInMinutes(), TimeUnit.MINUTES);
        FunctionalAdministrationReconstructionMetrics.initialize((FunctionalAdministrationReconstructionMetricsCache)reconstructionMetricsCache);
        this.reconstructionService = new ReconstructionServiceImpl(reconstructionFactory, new OffsetRepository((MongoDbAccess)this.mongoAccess), indexManager, reconstructionMetricsCache);
    }

    @Path(value="/reconstruction")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response reconstructCollections(@Context HttpHeaders headers, @Valid List<ReconstructionItem> reconstructionItems) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_JSON_MONDATORY_PARAMETERS_MSG, (Object[])new Object[]{reconstructionItems});
        if (!reconstructionItems.isEmpty()) {
            LOGGER.debug(String.format("Starting reconstruction Vitam service with the json parameters : (%s)", reconstructionItems));
            reconstructionItems.forEach(r -> {
                LOGGER.debug(String.format("Starting reconstruction for the collection {%s} on the tenants : (%s)", r.getCollection(), r.getTenants()));
                try {
                    this.reconstructionService.reconstruct(FunctionalAdminCollections.getFromValue((String)r.getCollection()), (Integer[])r.getTenants().toArray(Integer[]::new));
                }
                catch (DatabaseException e) {
                    LOGGER.error(RECONSTRUCTION_EXCEPTION_MSG, (Throwable)e);
                }
            });
        }
        return Response.ok().build();
    }

    @Path(value="/reconstruction/{collection}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response reconstructCollection(@Context HttpHeaders headers, @PathParam(value="collection") String collection) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_COLLECTION_MONDATORY_MSG, (String[])new String[]{collection});
        LOGGER.debug(String.format("Starting reconstruction Vitam service to reconstruct : (%s)", collection));
        try {
            this.reconstructionService.reconstruct(FunctionalAdminCollections.getFromValue((String)collection));
        }
        catch (DatabaseException e) {
            LOGGER.error("ERROR: Exception has been thrown when starting reconstruction service : ", (Throwable)e);
        }
        return Response.ok().build();
    }

    @Path(value="/accessionregisterreconstruction")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response reconstructCollection(List<ReconstructionRequestItem> reconstructionItems) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_JSON_MONDATORY_PARAMETERS_MSG, (Object[])new Object[]{reconstructionItems});
        ArrayList responses = new ArrayList();
        if (!reconstructionItems.isEmpty()) {
            LOGGER.debug(String.format("Starting reconstruction Vitam service with the json parameters : (%s)", reconstructionItems));
            reconstructionItems.forEach(item -> {
                LOGGER.debug(String.format("Starting reconstruction for the collection {%s} on the tenant (%s) with (%s) elements", item.getCollection(), item.getTenant(), item.getLimit()));
                try {
                    responses.add(this.reconstructionService.reconstructAccessionRegister(item));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(RECONSTRUCTION_EXCEPTION_MSG, (Throwable)e);
                    responses.add(new ReconstructionResponseItem(item, StatusCode.KO));
                }
            });
        }
        return Response.ok().entity(responses).build();
    }
}

