/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.core.contract.AccessContractImpl;
import fr.gouv.vitam.functional.administration.core.contract.IngestContractImpl;
import fr.gouv.vitam.functional.administration.core.contract.ManagementContractImpl;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class ContractResource {
    private static final String ADMIN_MODULE = "ADMIN_MODULE";
    static final String INGEST_CONTRACTS_URI = "/ingestcontracts";
    static final String ACCESS_CONTRACTS_URI = "/accesscontracts";
    static final String MANAGEMENT_CONTRACTS_URI = "/managementcontracts";
    static final String UPDATE_ACCESS_CONTRACTS_URI = "/accesscontracts";
    static final String UPDATE_INGEST_CONTRACTS_URI = "/ingestcontracts";
    static final String UPDATE_MANAGEMENT_CONTRACTS_URI = "/managementcontracts";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ContractResource.class);
    private static final String INGEST_CONTRACT_JSON_IS_MANDATORY_PATAMETER = "The json input of ingest contracts is mandatory";
    private static final String ACCESS_CONTRACT_JSON_IS_MANDATORY_PATAMETER = "The json input of access contracts is mandatory";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final VitamCounterService vitamCounterService;

    public ContractResource(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        LOGGER.debug("init Admin Management Resource server");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/ingestcontracts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importContracts(List<IngestContractModel> ingestContractModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)INGEST_CONTRACT_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{ingestContractModelList});
        try (IngestContractImpl ingestContract = new IngestContractImpl(this.mongoAccess, this.vitamCounterService);){
            RequestResponse requestResponse = ingestContract.createContracts(ingestContractModelList);
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    @GET
    @Path(value="/ingestcontracts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findIngestContracts(JsonNode queryDsl) {
        Response response;
        IngestContractImpl ingestContract = new IngestContractImpl(this.mongoAccess, this.vitamCounterService);
        try {
            RequestResponseOK ingestContractModelList = ingestContract.findContracts(queryDsl).setQuery(queryDsl);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)ingestContractModelList).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ingestContract.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
            }
        }
        ingestContract.close();
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/accesscontracts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importAccessContracts(List<AccessContractModel> accessContractModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)ACCESS_CONTRACT_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{accessContractModelList});
        try (AccessContractImpl accessContract = new AccessContractImpl(this.mongoAccess, this.vitamCounterService);){
            RequestResponse requestResponse = accessContract.createContracts(accessContractModelList);
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/accesscontracts/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAccessContract(@PathParam(value="id") String contractId, JsonNode queryDsl) {
        try (AccessContractImpl accessContract = new AccessContractImpl(this.mongoAccess, this.vitamCounterService);){
            RequestResponse requestResponse = accessContract.updateContract(contractId, queryDsl);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
                return response;
            }
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/ingestcontracts/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateIngestContract(@PathParam(value="id") String contractId, JsonNode queryDsl) {
        try (IngestContractImpl ingestContract = new IngestContractImpl(this.mongoAccess, this.vitamCounterService);){
            RequestResponse requestResponse = ingestContract.updateContract(contractId, queryDsl);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
                return response;
            }
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    @Path(value="/accesscontracts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findAccessContracts(JsonNode queryDsl) {
        Response response;
        AccessContractImpl accessContract = new AccessContractImpl(this.mongoAccess, this.vitamCounterService);
        try {
            RequestResponseOK accessContractModelList = accessContract.findContracts(queryDsl).setQuery(queryDsl);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)accessContractModelList).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    accessContract.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
            }
        }
        accessContract.close();
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/managementcontracts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importManagementContracts(List<ManagementContractModel> managementContractModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)ACCESS_CONTRACT_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{managementContractModelList});
        try (ManagementContractImpl managementContract = new ManagementContractImpl(this.mongoAccess, this.vitamCounterService);){
            RequestResponse requestResponse = managementContract.createContracts(managementContractModelList);
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    @Path(value="/managementcontracts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findManagementContracts(JsonNode queryDsl) {
        Response response;
        ManagementContractImpl managementContract = new ManagementContractImpl(this.mongoAccess, this.vitamCounterService);
        try {
            RequestResponseOK managementContractModelList = managementContract.findContracts(queryDsl).setQuery(queryDsl);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)managementContractModelList).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    managementContract.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
            }
        }
        managementContract.close();
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/managementcontracts/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateManagementContract(@PathParam(value="id") String contractId, JsonNode queryDsl) {
        try (ManagementContractImpl managementContract = new ManagementContractImpl(this.mongoAccess, this.vitamCounterService);){
            RequestResponse requestResponse = managementContract.updateContract(contractId, queryDsl);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
                return response;
            }
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
            return response;
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(ADMIN_MODULE).setState("code_vitam").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

