/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.functional.administration.core.archiveunitprofiles.ArchiveUnitProfileService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/adminmanagement/v1")
@ApplicationPath(value="webresources")
@Tag(name="Functional-Administration")
public class ArchiveUnitProfileResource {
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ArchiveUnitProfileResource.class);
    public static final String ARCHIVE_UNIT_PROFILE_URI = "/archiveunitprofiles";
    private static final String ARCHIVE_UNIT_PROFILE_JSON_IS_MANDATORY_PATAMETER = "The json input of archvie unit profile type is mandatory";
    private static final String DSL_QUERY_IS_MANDATORY_PATAMETER = "The dsl query is mandatory";
    private final ArchiveUnitProfileService archiveUnitProfileService;

    public ArchiveUnitProfileResource(ArchiveUnitProfileService archiveUnitProfileService) {
        this.archiveUnitProfileService = archiveUnitProfileService;
        LOGGER.debug("init Admin Management Resource server");
    }

    @Path(value="/archiveunitprofiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createProfiles(List<ArchiveUnitProfileModel> archiveUnitProfileModelList, @Context UriInfo uri) {
        ParametersChecker.checkParameter((String)ARCHIVE_UNIT_PROFILE_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{archiveUnitProfileModelList});
        try {
            RequestResponse requestResponse = this.archiveUnitProfileService.createArchiveUnitProfiles(archiveUnitProfileModelList);
            if (!requestResponse.isOk()) {
                requestResponse.setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
        }
        catch (VitamException exp) {
            LOGGER.error((Throwable)exp);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.getErrorEntity(Response.Status.BAD_REQUEST, exp.getMessage(), null)).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    @Path(value="/archiveunitprofiles/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateProfileFile(@PathParam(value="id") String profileMetadataId, JsonNode queryDsl) {
        ParametersChecker.checkParameter((String)ARCHIVE_UNIT_PROFILE_JSON_IS_MANDATORY_PATAMETER, (String[])new String[]{profileMetadataId});
        ParametersChecker.checkParameter((String)DSL_QUERY_IS_MANDATORY_PATAMETER, (Object[])new Object[]{queryDsl});
        try {
            SanityChecker.checkParameter((String[])new String[]{profileMetadataId});
            RequestResponse requestResponse = this.archiveUnitProfileService.updateArchiveUnitProfile(profileMetadataId, queryDsl);
            if (Response.Status.NOT_FOUND.getStatusCode() == requestResponse.getHttpCode()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)requestResponse).build();
            }
            if (!requestResponse.isOk()) {
                ((VitamError)requestResponse).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)requestResponse).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
        }
        catch (VitamException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage(), null)).build();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected server error {}", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
    }

    @GET
    @Path(value="/archiveunitprofiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findProfiles(JsonNode queryDsl) {
        try {
            RequestResponseOK profileModelList = this.archiveUnitProfileService.findArchiveUnitProfiles(queryDsl).setQuery(queryDsl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)profileModelList).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), null)).build();
        }
    }

    private VitamError<ArchiveUnitProfileModel> getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("ko").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

