/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.core.ontologies.OntologyService;
import fr.gouv.vitam.functional.administration.rest.OntologyResource;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/admin")
@Tag(name="Functional-Administration")
public class AdminOntologyResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminOntologyResource.class);
    private static final String FUNCTIONAL_ADMINISTRATION_MODULE = "FUNCTIONAL_ADMINISTRATION_MODULE";
    private final OntologyResource ontologyResource;
    public static final int ADMIN_TENANT = VitamConfiguration.getAdminTenant();
    private static final String ONTOLOGY_JSON_IS_MANDATORY_PATAMETER = "Ontology model list is mandatory";
    private final OntologyService ontologyService;

    public AdminOntologyResource(OntologyResource ontologyResource, OntologyService ontologyService) {
        LOGGER.debug("init Ontology Resource server");
        this.ontologyResource = ontologyResource;
        this.ontologyService = ontologyService;
    }

    @Path(value="/ontologies")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importInternalOntologies(List<OntologyModel> ontologyModelList, @Context UriInfo uri) {
        LOGGER.info("imports internal ontologies and merge them with external already used if any");
        LOGGER.info("use of admin tenant: 1");
        ParametersChecker.checkParameter((String)ONTOLOGY_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{ontologyModelList});
        try {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
            RequestResponse requestResponse = this.ontologyService.importInternalOntologies(ontologyModelList);
            if (!requestResponse.isOk()) {
                return Response.status((int)requestResponse.getHttpCode()).entity((Object)requestResponse).build();
            }
            return Response.created((URI)uri.getRequestUri().normalize()).entity((Object)requestResponse).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    @Path(value="/ontologies")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findOntologies(JsonNode queryDsl) {
        LOGGER.info("find ontology with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.ontologyResource.findOntologies(queryDsl);
    }

    @Path(value="/ontologies/cache")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findOntologiesForCache(JsonNode queryDsl) {
        LOGGER.info("find ontology with admin interface");
        LOGGER.info("using of admin tenant: 1");
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
        return this.ontologyResource.findOntologiesForCache(queryDsl);
    }

    @Path(value="/ontologies/check")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkOntologies(List<OntologyModel> ontologyModelList, @Context UriInfo uri) {
        LOGGER.info("This is check of the safety ontology import");
        LOGGER.info("use of admin tenant: 1");
        ParametersChecker.checkParameter((String)ONTOLOGY_JSON_IS_MANDATORY_PATAMETER, (Object[])new Object[]{ontologyModelList});
        try {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(ADMIN_TENANT));
            RequestResponse response = this.ontologyService.checkUpgradeOntologies(ontologyModelList);
            if (!response.isOk()) {
                return Response.status((int)response.getHttpCode()).entity((Object)response).build();
            }
            return Response.ok((Object)uri.getRequestUri().normalize()).entity((Object)response).build();
        }
        catch (Exception exp) {
            LOGGER.error("Unexpected server error {}", (Throwable)exp);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, exp.getMessage(), null)).build();
        }
    }

    private VitamError<OntologyModel> getErrorEntity(Response.Status status, String message, String code) {
        String aMessage = this.messageFromReason(status, message);
        String aCode = code != null ? code : String.valueOf(status.getStatusCode());
        return new VitamError(aCode).setHttpCode(status.getStatusCode()).setContext(FUNCTIONAL_ADMINISTRATION_MODULE).setState("code_vitam").setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    private String messageFromReason(Response.Status status, String message) {
        return message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
    }
}

