/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.client;

import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamThreadAccessException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.ProcessingRetryAsyncException;
import fr.gouv.vitam.worker.client.WorkerClient;
import fr.gouv.vitam.worker.client.WorkerClientFactory;
import fr.gouv.vitam.worker.client.exception.WorkerNotFoundClientException;
import fr.gouv.vitam.worker.client.exception.WorkerServerClientException;
import fr.gouv.vitam.worker.common.DescriptionStep;
import fr.gouv.vitam.worker.common.WorkerAccessRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

class WorkerClientRest
extends DefaultClient
implements WorkerClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerClientRest.class);
    private static final String DATA_MUST_HAVE_A_VALID_VALUE = "data must have a valid value";
    private static final GenericType<List<WorkerAccessRequest>> LIST_AR_TYPE = new GenericType<List<WorkerAccessRequest>>(){};

    WorkerClientRest(WorkerClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public ItemStatus submitStep(DescriptionStep step) throws WorkerNotFoundClientException, WorkerServerClientException, ProcessingRetryAsyncException {
        ItemStatus itemStatus;
        block8: {
            VitamThreadUtils.getVitamSession().checkValidRequestId();
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/tasks").withBody((Object)step, DATA_MUST_HAVE_A_VALID_VALUE).withJson();
            Response response = this.make(request);
            try {
                itemStatus = this.handleCommonResponseStatus(step, response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new WorkerServerClientException(e);
                }
            }
            response.close();
        }
        return itemStatus;
    }

    private ItemStatus handleCommonResponseStatus(DescriptionStep step, Response response) throws WorkerNotFoundClientException, WorkerServerClientException, ProcessingRetryAsyncException {
        if (CustomVitamHttpStatusCode.UNAVAILABLE_ASYNC_DATA_RETRY_LATER.getStatusCode() == response.getStatus()) {
            throw this.extractException(response);
        }
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        switch (status) {
            case OK: {
                return (ItemStatus)response.readEntity(ItemStatus.class);
            }
            case NOT_FOUND: {
                throw new WorkerNotFoundClientException(status.getReasonPhrase());
            }
        }
        try {
            LOGGER.error(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase() + " during execution of " + VitamThreadUtils.getVitamSession().getRequestId() + " Request, stepname:  " + step.getStep().getStepName() + " : " + status.getReasonPhrase());
        }
        catch (VitamThreadAccessException e) {
            LOGGER.error(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase() + " during execution of <unknown request id> Request, stepname:  " + step.getStep().getStepName() + " : " + status.getReasonPhrase());
        }
        throw new WorkerServerClientException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    private ProcessingRetryAsyncException extractException(Response response) {
        HashMap accessRequestIdByContext = new HashMap();
        List workerAccessRequests = (List)response.readEntity(LIST_AR_TYPE);
        workerAccessRequests.forEach(item -> {
            if (StringUtils.isEmpty((CharSequence)item.getAccessRequestId())) {
                throw new ProcessingException("Invalid accessRequestId was returned by worker");
            }
            accessRequestIdByContext.computeIfAbsent(new AccessRequestContext(item.getStrategyId(), item.getOfferId()), x -> new ArrayList()).add(item.getAccessRequestId());
        });
        return new ProcessingRetryAsyncException(accessRequestIdByContext);
    }
}

