/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.worker.client.WorkerClient;
import fr.gouv.vitam.worker.client.WorkerClientConfiguration;
import fr.gouv.vitam.worker.client.WorkerClientMock;
import fr.gouv.vitam.worker.client.WorkerClientRest;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WorkerClientFactory
extends VitamClientFactory<WorkerClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "worker-client.conf";
    private static final Map<WorkerClientConfiguration, WorkerClientFactory> workersSetFactory = new ConcurrentHashMap<WorkerClientConfiguration, WorkerClientFactory>();
    private static final WorkerClientFactory defaultWorkerClientFactory = new WorkerClientFactory(null);
    public static final String RESOURCE_PATH = "/worker/v1";

    private WorkerClientFactory(WorkerClientConfiguration configuration) {
        super((ClientConfiguration)configuration, RESOURCE_PATH, false);
    }

    public static WorkerClientFactory getInstance(WorkerClientConfiguration configuration) {
        if (configuration == null) {
            return defaultWorkerClientFactory;
        }
        workersSetFactory.computeIfAbsent(configuration, k -> new WorkerClientFactory(configuration));
        return workersSetFactory.get((Object)configuration);
    }

    public WorkerClient getClient() {
        WorkerClient client;
        switch (this.getVitamClientType()) {
            case MOCK: {
                client = new WorkerClientMock();
                break;
            }
            case PRODUCTION: {
                client = new WorkerClientRest(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Worker client type unknown");
            }
        }
        return client;
    }

    public static final WorkerClientConfiguration changeConfigurationFile(String configurationPath) {
        WorkerClientConfiguration configuration = null;
        try {
            configuration = (WorkerClientConfiguration)((Object)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), WorkerClientConfiguration.class));
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    public static final void changeMode(WorkerClientConfiguration configuration) {
        WorkerClientFactory.getInstance(configuration).initialisation((ClientConfiguration)configuration, WorkerClientFactory.getInstance(configuration).getResourcePath());
    }
}

