/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.format.identification.siegfried;

import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClient;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClientMock;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClientRest;

public class SiegfriedClientFactory
extends VitamClientFactory<SiegfriedClient> {
    private static final SiegfriedClientFactory Siegfried_CLIENT_FACTORY = new SiegfriedClientFactory();
    private static final String RESOURCE_PATH = "/identify";

    private SiegfriedClientFactory() {
        super(null, RESOURCE_PATH, false);
        this.disableUseAuthorizationFilter();
    }

    public static final SiegfriedClientFactory getInstance() {
        return Siegfried_CLIENT_FACTORY;
    }

    public SiegfriedClient getClient() {
        SiegfriedClient client;
        switch (this.getVitamClientType()) {
            case MOCK: {
                client = new SiegfriedClientMock();
                break;
            }
            case PRODUCTION: {
                client = new SiegfriedClientRest(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Log type unknown");
            }
        }
        return client;
    }

    final void changeConfiguration(String server, int port) {
        if (server == null || server.isEmpty() || port <= 0) {
            this.initialisation(null, this.getResourcePath());
            return;
        }
        this.initialisation((ClientConfiguration)new ClientConfigurationImpl(server, port), this.getResourcePath());
    }

    public static final void changeMode(String server, int port) {
        SiegfriedClientFactory.getInstance().initialisation((ClientConfiguration)new ClientConfigurationImpl(server, port), SiegfriedClientFactory.getInstance().getResourcePath());
    }

    public static final void changeMode(ClientConfiguration configuration) {
        SiegfriedClientFactory.getInstance().initialisation(configuration, SiegfriedClientFactory.getInstance().getResourcePath());
    }
}

