/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Updates;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;
import fr.gouv.vitam.functional.administration.common.server.ElasticsearchAccessFunctionalAdmin;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import java.util.Collection;
import java.util.Collections;
import org.bson.Document;
import org.bson.conversions.Bson;

@VisibleForTesting
public final class FunctionalAdminCollectionsTestUtils {
    private FunctionalAdminCollectionsTestUtils() {
    }

    @VisibleForTesting
    public static void beforeTestClass(MongoDatabase db, String prefix, ElasticsearchAccessFunctionalAdmin esClient) {
        FunctionalAdminCollectionsTestUtils.beforeTestClass(db, prefix, esClient, Lists.newArrayList((Object[])FunctionalAdminCollections.values()));
    }

    @VisibleForTesting
    public static void beforeTestClass(MongoDatabase db, String prefix, ElasticsearchAccessFunctionalAdmin esClient, Collection<FunctionalAdminCollections> functionalAdminCollections) {
        for (FunctionalAdminCollections collection : functionalAdminCollections) {
            if (collection == FunctionalAdminCollections.VITAM_SEQUENCE) continue;
            collection.getVitamCollection().setName(prefix + collection.getClasz().getSimpleName());
            collection.initialize(db, false);
            if (collection.getEsClient() == null) {
                collection.initialize(esClient);
                continue;
            }
            collection.initialize(collection.getEsClient());
        }
        if (functionalAdminCollections.contains((Object)FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL)) {
            FunctionalAdminCollections.ACCESSION_REGISTER_DETAIL.getCollection().createIndex((Bson)new Document("OriginatingAgency", (Object)1).append("Opi", (Object)1).append("_tenant", (Object)1), new IndexOptions().unique(true));
        }
        if (functionalAdminCollections.contains((Object)FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY)) {
            FunctionalAdminCollections.ACCESSION_REGISTER_SUMMARY.getCollection().createIndex((Bson)new Document("_tenant", (Object)1).append("OriginatingAgency", (Object)1), new IndexOptions().unique(true));
        }
    }

    @VisibleForTesting
    public static void afterTestClass(boolean deleteEsIndex) {
        FunctionalAdminCollectionsTestUtils.afterTestClass(Lists.newArrayList((Object[])FunctionalAdminCollections.values()), deleteEsIndex);
    }

    @VisibleForTesting
    public static void resetVitamSequenceCounter() {
        FunctionalAdminCollections.VITAM_SEQUENCE.getCollection().updateMany(Filters.exists((String)"_id"), Updates.set((String)"Counter", (Object)0));
    }

    @VisibleForTesting
    public static void afterTestClass(Collection<FunctionalAdminCollections> functionalAdminCollections, boolean deleteEsIndex) {
        ParametersChecker.checkParameter((String)"functionalAdminCollections is required", (Object[])new Object[]{functionalAdminCollections});
        try {
            for (FunctionalAdminCollections collection : functionalAdminCollections) {
                if (collection == FunctionalAdminCollections.VITAM_SEQUENCE) continue;
                if (null != collection.getVitamCollection().getCollection()) {
                    collection.getVitamCollection().getCollection().deleteMany((Bson)new Document());
                }
                if (collection.getEsClient() == null) continue;
                if (deleteEsIndex) {
                    collection.getEsClient().deleteIndexByAliasForTesting(ElasticsearchIndexAlias.ofCrossTenantCollection((String)collection.getName()));
                    continue;
                }
                collection.getEsClient().purgeIndexForTesting(ElasticsearchIndexAlias.ofCrossTenantCollection((String)collection.getName()));
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static void afterTest() {
        FunctionalAdminCollectionsTestUtils.afterTestClass(false);
    }

    @VisibleForTesting
    public static void afterTest(Collection<FunctionalAdminCollections> functionalAdminCollections) {
        FunctionalAdminCollectionsTestUtils.afterTestClass(functionalAdminCollections, false);
    }

    @VisibleForTesting
    public static ElasticsearchFunctionalAdminIndexManager createTestIndexManager() {
        return new ElasticsearchFunctionalAdminIndexManager(new AdminManagementConfiguration(Collections.emptyList(), null, null, null).setIndexationConfiguration(new FunctionalAdminIndexationConfiguration().setDefaultConfiguration(new CollectionConfiguration(Integer.valueOf(1), Integer.valueOf(0)))));
    }
}

