/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.IncAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitam.functional.administration.common.AccessionRegisterSummary;
import java.util.ArrayList;
import java.util.List;

public class ReferentialAccessionRegisterSummaryUtil {
    public AccessionRegisterSummary initAccessionRegisterSummary(String originatingAgency, String id) {
        RegisterValueDetailModel initialValue = new RegisterValueDetailModel();
        AccessionRegisterSummary accessionRegister = new AccessionRegisterSummary();
        accessionRegister.setId(id).setOriginatingAgency(originatingAgency).setTotalObjects(initialValue).setTotalObjectGroups(initialValue).setTotalUnits(initialValue).setObjectSize(initialValue).setCreationDate(LocalDateUtil.nowFormatted());
        return accessionRegister;
    }

    public Update generateUpdateQuery(AccessionRegisterDetailModel registerDetail) throws InvalidCreateOperationException {
        List<Action> actions = this.createActions(registerDetail);
        Update update = new Update();
        update.setQuery((Query)QueryHelper.eq((String)"OriginatingAgency", (String)registerDetail.getOriginatingAgency()));
        update.addActions((Action[])actions.toArray(new IncAction[actions.size()]));
        return update;
    }

    public List<Action> createActions(AccessionRegisterDetailModel registerDetail) throws InvalidCreateOperationException {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new IncAction("TotalObjectGroups.ingested", registerDetail.getTotalObjectsGroups().getIngested()));
        actions.add((Action)new IncAction("TotalObjectGroups.deleted", registerDetail.getTotalObjectsGroups().getDeleted()));
        actions.add((Action)new IncAction("TotalObjectGroups.remained", registerDetail.getTotalObjectsGroups().getRemained()));
        actions.add((Action)new IncAction("TotalObjects.ingested", registerDetail.getTotalObjects().getIngested()));
        actions.add((Action)new IncAction("TotalObjects.deleted", registerDetail.getTotalObjects().getDeleted()));
        actions.add((Action)new IncAction("TotalObjects.remained", registerDetail.getTotalObjects().getRemained()));
        actions.add((Action)new IncAction("TotalUnits.ingested", registerDetail.getTotalUnits().getIngested()));
        actions.add((Action)new IncAction("TotalUnits.deleted", registerDetail.getTotalUnits().getDeleted()));
        actions.add((Action)new IncAction("TotalUnits.remained", registerDetail.getTotalUnits().getRemained()));
        actions.add((Action)new IncAction("ObjectSize.ingested", registerDetail.getObjectSize().getIngested()));
        actions.add((Action)new IncAction("ObjectSize.deleted", registerDetail.getObjectSize().getDeleted()));
        actions.add((Action)new IncAction("ObjectSize.remained", registerDetail.getObjectSize().getRemained()));
        return actions;
    }
}

