/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.HttpHeaderHelper;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.processing.common.async.ProcessingRetryAsyncException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.DescriptionStep;
import fr.gouv.vitam.worker.common.WorkerAccessRequest;
import fr.gouv.vitam.worker.core.api.Worker;
import fr.gouv.vitam.worker.core.impl.WorkerFactory;
import fr.gouv.vitam.worker.core.plugin.PluginLoader;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/worker/v1")
@Tag(name="Worker")
public class WorkerResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerResource.class);
    private static final String WORKER_MODULE = "WORKER";
    private static final String CODE_VITAM = "code_vitam";
    private final WorkerFactory workerFactory;
    private final Worker workerMocked;

    WorkerResource(PluginLoader pluginLoader) {
        LOGGER.info("init Worker Resource server");
        this.workerMocked = null;
        this.workerFactory = WorkerFactory.getInstance((PluginLoader)pluginLoader);
    }

    WorkerResource(PluginLoader pluginLoader, Worker worker) {
        LOGGER.info("init Worker Resource server");
        this.workerMocked = worker;
        this.workerFactory = WorkerFactory.getInstance((PluginLoader)pluginLoader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="tasks")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="submit a step to be launched", description="Permet de soumettre une t\u00e2che (steps + contexte + item)")
    public Response submitStep(@Context HttpHeaders headers, JsonNode descriptionStepJson) {
        HttpHeaderHelper.checkVitamHeaders((HttpHeaders)headers);
        try {
            ParametersChecker.checkParameter((String)"Must have a step description", (Object[])new Object[]{descriptionStepJson});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)descriptionStepJson));
            DescriptionStep descriptionStep = (DescriptionStep)JsonHandler.getFromJsonNode((JsonNode)descriptionStepJson, DescriptionStep.class);
            if (this.workerMocked != null) {
                ItemStatus responses = this.workerMocked.run(descriptionStep.getWorkParams(), descriptionStep.getStep());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)responses).build();
            }
            try (Worker worker = this.workerFactory.create();){
                ItemStatus responses = worker.run(descriptionStep.getWorkParams(), descriptionStep.getStep());
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)responses).build();
                return response;
            }
        }
        catch (InvalidParseOperationException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorEntity(Response.Status.PRECONDITION_FAILED)).build();
        }
        catch (ProcessingRetryAsyncException retryExc) {
            LOGGER.warn((Throwable)retryExc);
            ArrayList entity = new ArrayList();
            retryExc.getAccessRequestIdByContext().forEach((key, value) -> value.forEach(accessRequestId -> entity.add(new WorkerAccessRequest(accessRequestId, key.getStrategyId(), key.getOfferId()))));
            return Response.status((int)CustomVitamHttpStatusCode.UNAVAILABLE_ASYNC_DATA_RETRY_LATER.getStatusCode()).entity(entity).build();
        }
        catch (ProcessingException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST)).build();
        }
    }

    private VitamError getErrorEntity(Response.Status status) {
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(WORKER_MODULE).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(status.getReasonPhrase());
    }
}

