/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.server.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.worker.server.registration.WorkerRegistrationListener;
import fr.gouv.vitam.worker.server.rest.BusinessApplication;
import fr.gouv.vitam.worker.server.rest.WorkerConfiguration;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WorkerMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerMain.class);
    private static final String CONF_FILE_NAME = "ingest-internal.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.logbook.port";
    private final VitamStarter vitamStarter;

    public WorkerMain(String configurationFile) throws IOException {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        ArrayList<WorkerRegistrationListener> listeners = new ArrayList<WorkerRegistrationListener>();
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            WorkerConfiguration configuration = (WorkerConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, WorkerConfiguration.class));
            listeners.add(new WorkerRegistrationListener(configuration));
        }
        if (Security.getProvider("BC") == null) {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            Security.addProvider((Provider)provider);
        }
        this.vitamStarter = new VitamStarter(WorkerConfiguration.class, configurationFile, BusinessApplication.class, AdminApplication.class, listeners, false);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            WorkerMain main = new WorkerMain(args[0]);
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)args[0]);){
                WorkerConfiguration configuration = (WorkerConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, WorkerConfiguration.class));
                WorkspaceClientFactory.changeMode((String)configuration.getUrlWorkspace(), (WorkspaceType)WorkspaceType.VITAM);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            serviceRegistry.register((VitamClientFactoryInterface)LogbookLifeCyclesClientFactory.getInstance()).register((VitamClientFactoryInterface)WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM)).register((VitamClientFactoryInterface)MetaDataClientFactory.getInstance());
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            main.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }

    public VitamStarter getVitamStarter() {
        return this.vitamStarter;
    }
}

