/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.server.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.processing.common.exception.PluginException;
import fr.gouv.vitam.worker.core.api.Worker;
import fr.gouv.vitam.worker.core.plugin.PluginLoader;
import fr.gouv.vitam.worker.core.validation.MetadataValidationProvider;
import fr.gouv.vitam.worker.server.rest.WorkerConfiguration;
import fr.gouv.vitam.worker.server.rest.WorkerResource;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;
    static Worker mock = null;
    private PluginLoader pluginLoader;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            this.pluginLoader = new PluginLoader();
            this.pluginLoader.loadConfiguration();
            this.checkPluginsCreation();
            WorkerConfiguration configuration = (WorkerConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, WorkerConfiguration.class));
            MetadataValidationProvider.getInstance().initialize(AdminManagementClientFactory.getInstance(), VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), configuration.getArchiveUnitProfileCacheMaxEntries(), configuration.getArchiveUnitProfileCacheTimeoutInSeconds(), configuration.getSchemaValidatorCacheMaxEntries(), configuration.getSchemaValidatorCacheTimeoutInSeconds());
            this.commonBusinessApplication = new CommonBusinessApplication();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            if (mock != null) {
                this.singletons.add((Object)new WorkerResource(this.pluginLoader, mock));
            } else {
                WorkspaceClientFactory.changeMode((String)configuration.getUrlWorkspace(), (WorkspaceType)WorkspaceType.VITAM);
                this.singletons.add((Object)new WorkerResource(this.pluginLoader));
            }
        }
        catch (InvalidParseOperationException | IllegalPathException | PluginException | IOException e) {
            throw new VitamRuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    private void checkPluginsCreation() throws PluginException {
        this.pluginLoader.loadAllPlugins();
    }
}

