/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.server.registration;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.worker.server.registration.WorkerRegister;
import fr.gouv.vitam.worker.server.rest.WorkerConfiguration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class WorkerRegistrationListener
implements ServletContextListener {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerRegistrationListener.class);
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)VitamThreadFactory.getInstance());
    private final WorkerConfiguration configuration;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final WorkerRegister workerRegister;

    public WorkerRegistrationListener(WorkerConfiguration configuration) {
        this.configuration = configuration;
        ProcessingManagementClientFactory.changeConfigurationUrl((String)configuration.getProcessingUrl());
        this.processingManagementClientFactory = ProcessingManagementClientFactory.getInstance();
        this.workerRegister = new WorkerRegister(configuration, this.processingManagementClientFactory);
    }

    @VisibleForTesting
    public WorkerRegistrationListener(WorkerConfiguration configuration, ProcessingManagementClientFactory processingManagementClientFactory) {
        this.configuration = configuration;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.workerRegister = new WorkerRegister(configuration, processingManagementClientFactory);
    }

    public void contextInitialized(ServletContextEvent sce) {
        LOGGER.debug("ServletContextListener started");
        this.executorService.scheduleWithFixedDelay(this.workerRegister, 0L, this.configuration.getRegisterDelay(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        LOGGER.debug("ServletContextListener destroyed");
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn((Throwable)e);
        }
        finally {
            try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();){
                processingClient.unregisterWorker(this.configuration.getWorkerFamily(), String.valueOf(ServerIdentity.getInstance().getGlobalPlatformId()));
            }
            catch (Exception e) {
                LOGGER.error("WorkerUnRegister run : unregister call failed => Processing (" + this.configuration.getProcessingUrl() + ") will unregister worker automatically ", (Throwable)e);
            }
        }
    }
}

