/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.server.registration;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.common.model.WorkerRemoteConfiguration;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.worker.server.rest.WorkerConfiguration;

public class WorkerRegister
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerRegister.class);
    private final WorkerConfiguration configuration;
    public static final String DEFAULT_FAMILY = "DefaultWorker";
    private final ProcessingManagementClientFactory processingManagementClientFactory;

    @VisibleForTesting
    public WorkerRegister(WorkerConfiguration configuration, ProcessingManagementClientFactory processingManagementClientFactory) {
        this.configuration = configuration;
        this.processingManagementClientFactory = processingManagementClientFactory;
    }

    @Override
    public synchronized void run() {
        LOGGER.debug("WorkerRegister run : begin");
        WorkerRemoteConfiguration remoteConfiguration = new WorkerRemoteConfiguration(this.configuration.getRegisterServerHost(), this.configuration.getRegisterServerPort());
        WorkerBean workerBean = new WorkerBean(ServerIdentity.getInstance().getName(), this.configuration.getWorkerFamily(), this.configuration.getCapacity(), "active", remoteConfiguration);
        try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();){
            processingClient.registerWorker(this.configuration.getWorkerFamily(), String.valueOf(ServerIdentity.getInstance().getGlobalPlatformId()), workerBean);
        }
        catch (Exception e) {
            LOGGER.error("WorkerRegister failed (" + this.configuration.getProcessingUrl() + ").Retry in " + this.configuration.getRegisterDelay() + " seconds", (Throwable)e);
        }
        LOGGER.debug("WorkerRegister run : end");
    }
}

