/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.collect.common.dto.ObjectDto;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.internal.core.common.CollectUnitModel;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.service.CollectService;
import fr.gouv.vitam.collect.internal.core.service.MetadataService;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.DbObjectGroupModel;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import java.io.InputStream;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/collect-internal/v1")
public class CollectMetadataInternalResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectMetadataInternalResource.class);
    private final MetadataService metadataService;
    private final CollectService collectService;
    private final TransactionService transactionService;

    public CollectMetadataInternalResource(MetadataService metadataService, CollectService collectService, TransactionService transactionService) {
        this.metadataService = metadataService;
        this.collectService = collectService;
        this.transactionService = transactionService;
    }

    @Path(value="/units/{unitId}")
    @GET
    @Produces(value={"application/json"})
    public Response getUnitById(@PathParam(value="unitId") String unitId) {
        try {
            JsonNode response = this.metadataService.selectUnitById(unitId);
            return CollectRequestResponse.toResponseOK((Object)response);
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when fetching unit in metadata : {}", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error when fetching unit in metadata : {}", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/units/{unitId}/objects/{usage}/{version}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response uploadObjectGroup(@PathParam(value="unitId") String unitId, @PathParam(value="usage") String usageString, @PathParam(value="version") Integer version, @Valid ObjectDto objectDto) {
        try {
            SanityChecker.checkParameter((String[])new String[]{unitId});
            SanityChecker.checkParameter((String[])new String[]{usageString});
            ParametersChecker.checkParameter((String)"You must supply object datas!", (Object[])new Object[]{objectDto});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)objectDto));
            DataObjectVersionType usage = CollectHelper.fetchUsage((String)usageString);
            ParametersChecker.checkParameter((String)"usage({}), unitId({}) or version({}) can't be null", (Object[])new Object[]{unitId, usage, version});
            CollectUnitModel archiveUnitModel = this.collectService.getArchiveUnitModel(unitId);
            ObjectDto savedObjectDto = this.collectService.updateOrSaveObjectGroup(archiveUnitModel, usage, version.intValue(), objectDto);
            return CollectRequestResponse.toResponseOK((Object)savedObjectDto);
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error while trying to save objects : {}", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error while trying to save objects : {}", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/objects/{gotId}")
    @GET
    @Produces(value={"application/json"})
    public Response getObjectById(@PathParam(value="gotId") String gotId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{gotId});
            JsonNode objectGroup = this.metadataService.selectObjectGroupById(gotId);
            return CollectRequestResponse.toResponseOK((Object)objectGroup);
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when fetching object in metadata : {}", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("Error when fetching object in metadata : {}", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/units/{unitId}/objects/{usage}/{version}/binary")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response upload(@PathParam(value="unitId") String unitId, @PathParam(value="usage") String usageString, @PathParam(value="version") Integer version, InputStream uploadedInputStream) throws CollectInternalException {
        try {
            SanityChecker.checkParameter((String[])new String[]{unitId});
            SanityChecker.checkParameter((String[])new String[]{usageString});
            SanityChecker.checkParameter((String[])new String[]{String.valueOf(version)});
            ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{uploadedInputStream});
            DataObjectVersionType usage = CollectHelper.fetchUsage((String)usageString);
            ParametersChecker.checkParameter((String)"usage({}), unitId({}) or version({}) can't be null", (Object[])new Object[]{unitId, usage, version});
            CollectUnitModel archiveUnitModel = this.collectService.getArchiveUnitModel(unitId);
            if (archiveUnitModel == null) {
                throw new CollectInternalException("UA not found");
            }
            if (archiveUnitModel.getOpi() != null && !archiveUnitModel.getOpi().isBlank()) {
                TransactionModel uaTransaction = this.transactionService.findTransaction(archiveUnitModel.getOpi()).orElse(null);
                if (uaTransaction == null) {
                    throw new CollectInternalException("Transaction Id not found");
                }
                if (!uaTransaction.getStatus().equals((Object)TransactionStatus.OPEN)) {
                    throw new CollectInternalException("Invalid transaction status");
                }
            } else {
                throw new CollectInternalException("Operation Id not found");
            }
            DbObjectGroupModel dbObjectGroupModel = this.collectService.getDbObjectGroup(archiveUnitModel);
            this.collectService.addBinaryInfoToQualifier(dbObjectGroupModel, usage, version.intValue(), uploadedInputStream);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalException e) {
            LOGGER.debug("An error occurs when try to fetch data from database : {}", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to fetch data from database : {}", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/units/{unitId}/objects/{usage}/{version}/binary")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response download(@PathParam(value="unitId") String unitId, @PathParam(value="usage") String usageString, @PathParam(value="version") Integer version) {
        try {
            SanityChecker.checkParameter((String[])new String[]{unitId});
            SanityChecker.checkParameter((String[])new String[]{usageString});
            SanityChecker.checkParameter((String[])new String[]{String.valueOf(version)});
            DataObjectVersionType usage = CollectHelper.fetchUsage((String)usageString);
            ParametersChecker.checkParameter((String)"usage({}), unitId({}) or version({}) can't be null", (Object[])new Object[]{unitId, usage, version});
            CollectUnitModel archiveUnitModel = this.collectService.getArchiveUnitModel(unitId);
            this.collectService.getDbObjectGroup(archiveUnitModel);
            return this.collectService.getBinaryByUsageAndVersion(archiveUnitModel, usage, version.intValue());
        }
        catch (CollectInternalException e) {
            LOGGER.debug("An error occurs when try to fetch binary from database : {}", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurs when try to fetch binary from database : {}", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageNotFoundException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

