/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.client.v2;

import fr.gouv.vitam.access.external.client.v2.AccessExternalClientV2;
import fr.gouv.vitam.access.external.client.v2.AccessExternalClientV2Rest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.external.client.VitamClientFactory;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfiguration;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;

public class AccessExternalClientV2Factory
extends VitamClientFactory<AccessExternalClientV2> {
    private static final String CONFIGURATION_FILENAME = "access-external-client.conf";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessExternalClientV2Factory.class);
    private static final AccessExternalClientV2Factory ACCESS_CLIENT_FACTORY = new AccessExternalClientV2Factory();
    private static final String RESOURCE_PATH = "/access-external/v2";

    protected AccessExternalClientV2Factory() {
        super((ClientConfiguration)AccessExternalClientV2Factory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static final AccessExternalClientV2Factory getInstance() {
        return ACCESS_CLIENT_FACTORY;
    }

    static final SecureClientConfiguration changeConfigurationFile(String configurationPath) {
        SecureClientConfiguration configuration = null;
        try {
            configuration = (SecureClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public AccessExternalClientV2 getClient() {
        return new AccessExternalClientV2Rest(this);
    }

    public static void changeMode(ClientConfiguration configuration) {
        AccessExternalClientV2Factory.getInstance().initialisation(configuration, AccessExternalClientV2Factory.getInstance().getResourcePath());
    }
}

