/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.client;

import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;

public class VitamPoolingClient {
    private OperationStatusClient operationStatusClient;

    public VitamPoolingClient(OperationStatusClient operationStatusClient) {
        ParametersChecker.checkParameter((String)"OperationStatusClient is required.", (Object[])new Object[]{operationStatusClient});
        this.operationStatusClient = operationStatusClient;
    }

    public boolean wait(int tenantId, String processId, ProcessState state, int nbTry, long timeWait, TimeUnit timeUnit) throws VitamException {
        StopWatch stopWatch = StopWatch.createStarted();
        do {
            RequestResponse<ItemStatus> requestResponse;
            if ((requestResponse = this.operationStatusClient.getOperationProcessStatus(new VitamContext(Integer.valueOf(tenantId)), processId)).isOk()) {
                ItemStatus itemStatus = (ItemStatus)((RequestResponseOK)requestResponse).getResults().get(0);
                ProcessState processState = itemStatus.getGlobalState();
                StatusCode statusCode = itemStatus.getGlobalStatus();
                switch (processState) {
                    case COMPLETED: {
                        return true;
                    }
                    case PAUSE: {
                        if (StatusCode.STARTED.compareTo((Enum)statusCode) <= 0) {
                            return true;
                        }
                        if (stopWatch.getTime(TimeUnit.MINUTES) < 1L) break;
                        return false;
                    }
                }
                if (null != timeUnit) {
                    timeWait = timeUnit.toMillis(timeWait);
                }
                if (--nbTry <= 0) continue;
                try {
                    Thread.sleep(timeWait);
                }
                catch (InterruptedException e) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                }
                continue;
            }
            throw new VitamException((VitamError)requestResponse);
        } while (nbTry > 0);
        return false;
    }

    public boolean wait(int tenantId, String processId, int nbTry, long timeout, TimeUnit timeUnit) throws VitamException {
        return this.wait(tenantId, processId, ProcessState.COMPLETED, nbTry, timeout, timeUnit);
    }

    public boolean wait(int tenantId, String processId, ProcessState state) throws VitamException {
        return this.wait(tenantId, processId, state, Integer.MAX_VALUE, 1000L, TimeUnit.MILLISECONDS);
    }

    public boolean wait(int tenantId, String processId) throws VitamException {
        return this.wait(tenantId, processId, ProcessState.COMPLETED);
    }
}

