/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AccessExternalClientFactory;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientNotFoundException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientAccessUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientIllegalAccessRequestOperationOnSyncOfferException;
import fr.gouv.vitam.common.external.client.DefaultClient;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.JsonLineIterator;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitam.common.model.identifier.PurgedPersistentIdentifier;
import fr.gouv.vitam.common.model.logbook.LogbookLifecycle;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.storage.AccessRequestReference;
import fr.gouv.vitam.common.model.storage.StatusByAccessRequest;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import javax.ws.rs.core.Response;

class AccessExternalClientRest
extends DefaultClient
implements AccessExternalClient {
    public static final String BLANK_QUERY = "selectQuery cannot be null.";
    public static final String PATH_STREAM_OBJECTS = "/objects/stream";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessExternalClientRest.class);
    private static final String UNITS = "/units/";
    private static final String UNITS_ATOMIC_BULK = "/units/bulk/";
    private static final String UNITS_RULES = "/units/rules";
    private static final String LOGBOOK_OPERATIONS_URL = "/logbookoperations";
    private static final String LOGBOOK_UNIT_LIFECYCLE_URL = "/logbookunitlifecycles";
    private static final String LOGBOOK_OBJECT_LIFECYCLE_URL = "/logbookobjectslifecycles";
    private static final String BLANK_UNIT_ID = "unit identifier should be filled";
    private static final String BLANK_OBJECT_ID = "object identifier should be filled";
    private static final String BLANK_OBJECT_GROUP_ID = "object identifier should be filled";
    private static final String BLANK_DIP_ID = "DIP identifier should be filled";
    private static final String BLANK_TRANSFER_ID = "Transfer identifier should be filled";
    private static final String MISSING_RECLASSIFICATION_REQUEST = "Missing reclassification request";
    private static final String MISSING_ELIMINATION_REQUEST = "Missing elimination request";

    AccessExternalClientRest(AccessExternalClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public RequestResponse<JsonNode> selectUnits(VitamContext vitamContext, JsonNode selectQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/units").withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery, BLANK_QUERY).withJson();
        try (Response response = this.make(request);){
            Response.Status status = response.getStatusInfo().toEnum();
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
                LOGGER.error(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
                LOGGER.warn("We should have throw an exception in this case but we cannot, because it will break this API.");
            }
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public JsonLineIterator<JsonNode> streamUnits(VitamContext vitamContext, JsonNode selectQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/units/stream").withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery, BLANK_QUERY).withJsonContentType().withOctetAccept();
        try (Response response = this.make(request);){
            this.check(response);
            JsonLineIterator jsonLineIterator = JsonLineIterator.parseFromResponse((Response)response, JsonNode.class);
            return jsonLineIterator;
        }
    }

    @Override
    public JsonLineIterator<JsonNode> streamObjects(VitamContext vitamContext, JsonNode selectQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(PATH_STREAM_OBJECTS).withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery, BLANK_QUERY).withJsonContentType().withOctetAccept();
        try (Response response = this.make(request);){
            this.check(response);
            JsonLineIterator jsonLineIterator = JsonLineIterator.parseFromResponse((Response)response, JsonNode.class);
            return jsonLineIterator;
        }
    }

    @Override
    public RequestResponse<JsonNode> selectUnitbyId(VitamContext vitamContext, JsonNode selectQuery, String unitId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_UNIT_ID, (String[])new String[]{unitId});
        try (Response response = this.make(VitamRequestBuilder.get().withPath(UNITS + unitId).withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery, BLANK_QUERY).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> updateUnitbyId(VitamContext vitamContext, JsonNode updateQuery, String unitId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_UNIT_ID, (String[])new String[]{unitId});
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(UNITS + unitId).withHeaders(vitamContext.getHeaders()).withBody((Object)updateQuery, BLANK_QUERY).withJson();
        try (Response response = this.make(request);){
            Response.Status status = response.getStatusInfo().toEnum();
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
                LOGGER.error(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
                LOGGER.warn("We should have throw an exception in this case but we cannot, because it will break this API.");
            }
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> selectObjectMetadatasByUnitId(VitamContext vitamContext, JsonNode selectObjectQuery, String unitId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(UNITS + unitId + "/objects").withHeaders(vitamContext.getHeaders()).withBody((Object)selectObjectQuery, "object identifier should be filled").withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getObjectStreamByUnitId(VitamContext vitamContext, String unitId, String usage, int version) throws VitamClientException {
        ParametersChecker.checkParameter((String)"object identifier should be filled", (String[])new String[]{unitId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(UNITS + unitId + "/objects").withHeaders(vitamContext.getHeaders()).withHeader("X-Qualifier", (Object)usage).withHeader("X-Version", (Object)version).withJsonContentType().withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            if (response.getStatus() == 460) {
                throw new VitamClientAccessUnavailableDataFromAsyncOfferException("Object unavailable for immediate access. Access Request required");
            }
            this.check(response);
            Response response2 = response;
            return response2;
        }
        finally {
            if (response != null && Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse<AccessRequestReference> createObjectAccessRequestByUnitId(VitamContext vitamContext, String unitId, String usage, int version) throws VitamClientException, AccessExternalClientNotFoundException {
        ParametersChecker.checkParameter((String)"object identifier should be filled", (String[])new String[]{unitId});
        ParametersChecker.checkParameter((String)"Missing usage", (String[])new String[]{usage});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(UNITS + URLEncoder.encode(unitId, StandardCharsets.UTF_8) + "/objects/accessRequests").withHeaders(vitamContext.getHeaders()).withHeader("X-Qualifier", (Object)usage).withHeader("X-Version", (Object)version).withJson();
        try (Response response = this.make(request);){
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new AccessExternalClientNotFoundException("No such object matching unitId and object qualifier usage & version");
            }
            if (response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new AccessUnauthorizedException("Access forbidden to object with specified qualifier usage & version");
            }
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, AccessRequestReference.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<StatusByAccessRequest> checkAccessRequestStatuses(VitamContext vitamContext, Collection<AccessRequestReference> accessRequestReferences) throws VitamClientException {
        ParametersChecker.checkParameter((String)"Access requests required", (Object[])new Object[]{accessRequestReferences});
        for (AccessRequestReference accessRequestReference : accessRequestReferences) {
            ParametersChecker.checkParameter((String)"Access requests required", (Object[])new Object[]{accessRequestReference});
            ParametersChecker.checkParameter((String)"Required accessRequestId", (String[])new String[]{accessRequestReference.getAccessRequestId()});
            ParametersChecker.checkParameter((String)"Required storageStrategyId", (String[])new String[]{accessRequestReference.getStorageStrategyId()});
        }
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/accessRequests").withHeaders(vitamContext.getHeaders()).withJson().withBody(accessRequestReferences);
        try (Response response = this.make(request);){
            if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
                throw new VitamClientIllegalAccessRequestOperationOnSyncOfferException(String.format("Illegal operation on storage engine, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
            }
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, StatusByAccessRequest.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<Void> removeAccessRequest(VitamContext vitamContext, AccessRequestReference accessRequestReference) throws VitamClientException {
        ParametersChecker.checkParameter((String)"Access request required", (Object[])new Object[]{accessRequestReference});
        ParametersChecker.checkParameter((String)"Required accessRequestId", (String[])new String[]{accessRequestReference.getAccessRequestId()});
        ParametersChecker.checkParameter((String)"Required storageStrategyId", (String[])new String[]{accessRequestReference.getStorageStrategyId()});
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/accessRequests").withHeaders(vitamContext.getHeaders()).withJsonContentType().withBody((Object)accessRequestReference);
        try (Response response = this.make(request);){
            if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
                throw new VitamClientIllegalAccessRequestOperationOnSyncOfferException(String.format("Illegal operation on storage engine, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
            }
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, Void.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<LogbookOperation> selectOperations(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath(LOGBOOK_OPERATIONS_URL).withHeaders(vitamContext.getHeaders()).withBody((Object)select).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, LogbookOperation.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<LogbookOperation> selectOperationbyId(VitamContext vitamContext, String processId, JsonNode select) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/logbookoperations/" + processId).withHeaders(vitamContext.getHeaders()).withBody((Object)select, BLANK_QUERY).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, LogbookOperation.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<LogbookLifecycle> selectUnitLifeCycleById(VitamContext vitamContext, String idUnit, JsonNode select) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/logbookunitlifecycles/" + idUnit).withHeaders(vitamContext.getHeaders()).withBody((Object)select, BLANK_QUERY).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, LogbookLifecycle.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<LogbookLifecycle> selectObjectGroupLifeCycleById(VitamContext vitamContext, String idObject, JsonNode select) throws VitamClientException {
        ParametersChecker.checkParameter((String)"object identifier should be filled", (String[])new String[]{idObject});
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/logbookobjectslifecycles/" + idObject).withHeaders(vitamContext.getHeaders()).withBody((Object)select, BLANK_QUERY).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, LogbookLifecycle.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> exportDIP(VitamContext vitamContext, JsonNode dslRequest) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/dipexport").withHeaders(vitamContext.getHeaders()).withBody((Object)dslRequest, "dslRequest cannot be null.").withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> transfer(VitamContext vitamContext, TransferRequest transferRequest) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transfers").withHeaders(vitamContext.getHeaders()).withBody((Object)transferRequest).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public Response getTransferById(VitamContext vitamContext, String transferId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_TRANSFER_ID, (String[])new String[]{transferId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transfers/" + transferId + "/sip").withHeaders(vitamContext.getHeaders()).withJsonContentType().withOctetAccept();
        return this.make(request);
    }

    @Override
    public Response getDIPById(VitamContext vitamContext, String dipId) throws VitamClientException {
        ParametersChecker.checkParameter((String)BLANK_DIP_ID, (String[])new String[]{dipId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/dipexport/" + dipId + "/dip").withHeaders(vitamContext.getHeaders()).withJsonContentType().withOctetAccept();
        return this.make(request);
    }

    @Override
    public RequestResponse<JsonNode> reclassification(VitamContext vitamContext, JsonNode reclassificationRequest) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/reclassification").withHeaders(vitamContext.getHeaders()).withBody((Object)reclassificationRequest, MISSING_RECLASSIFICATION_REQUEST).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> massUpdateUnits(VitamContext vitamContext, JsonNode updateQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(UNITS).withHeaders(vitamContext.getHeaders()).withBody((Object)updateQuery).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> massUpdateUnitsRules(VitamContext vitamContext, JsonNode updateRulesQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(UNITS_RULES).withHeaders(vitamContext.getHeaders()).withBody((Object)updateRulesQuery).withJson();
        try (Response response = this.make(request);){
            Response.Status status = response.getStatusInfo().toEnum();
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
                LOGGER.error(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
                LOGGER.warn("We should have throw an exception in this case but we cannot, because it will break this API.");
            }
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> bulkAtomicUpdateUnits(VitamContext vitamContext, JsonNode updateRequest) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(UNITS_ATOMIC_BULK).withHeaders(vitamContext.getHeaders()).withBody((Object)updateRequest).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> revertUpdateUnits(VitamContext vitamContext, JsonNode revertUpdateQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/revert/units").withHeaders(vitamContext.getHeaders()).withBody((Object)revertUpdateQuery).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> selectObjects(VitamContext vitamContext, JsonNode selectQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/objects").withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery, BLANK_QUERY).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> selectUnitsByUnitPersistentIdentifier(VitamContext vitamContext, JsonNode selectQuery, String persistentIdentifier) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/units/unitpid/" + persistentIdentifier).withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery, BLANK_QUERY).withJson();
        try (Response response = this.make(request);){
            Response.Status status = response.getStatusInfo().toEnum();
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
                LOGGER.error(String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase()));
                LOGGER.warn("We should have throw an exception in this case but we cannot, because it will break this API.");
            }
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getObjectByUnitPersistentIdentifier(VitamContext vitamContext, String persistentIdentifier, String qualifier, String version) throws VitamClientException {
        ParametersChecker.checkParameter((String)"Persistent identifier should not be empty", (String[])new String[]{persistentIdentifier});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/objects/unitpid/" + persistentIdentifier).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        if (version != null && qualifier == null) {
            throw new IllegalArgumentException("Illegal call with only version parameter, please provide qualifier");
        }
        if (qualifier != null && !qualifier.isEmpty()) {
            request.withQueryParam("qualifier", qualifier);
        }
        if (version != null && !version.isEmpty()) {
            request.withQueryParam("version", version);
        }
        Response response = null;
        try {
            response = this.make(request);
            if (response.getStatus() == 460) {
                throw new VitamClientAccessUnavailableDataFromAsyncOfferException("Object unavailable for immediate access. Access Request required");
            }
            this.check(response);
            Response response2 = response;
            return response2;
        }
        finally {
            if (response != null && Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestResponse<JsonNode> getObjectByObjectPersistentIdentifier(VitamContext vitamContext, JsonNode selectQuery, String persistentIdentifier) throws VitamClientException {
        ParametersChecker.checkParameter((String)"Persistent identifier should not be empty", (String[])new String[]{persistentIdentifier});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/objects/objectpid/" + persistentIdentifier).withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery, BLANK_QUERY).withJson();
        Response response = null;
        try {
            response = this.make(request);
            if (response.getStatus() == 460) {
                throw new VitamClientAccessUnavailableDataFromAsyncOfferException("Object unavailable for immediate access. Access Request required");
            }
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
        finally {
            if (response != null && Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response downloadObjectByObjectPersistentIdentifier(VitamContext vitamContext, String persistentIdentifier) throws VitamClientException {
        ParametersChecker.checkParameter((String)"Persistent identifier should not be empty", (String[])new String[]{persistentIdentifier});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/objects/objectpid/" + persistentIdentifier).withHeaders(vitamContext.getHeaders()).withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            if (response.getStatus() == 460) {
                throw new VitamClientAccessUnavailableDataFromAsyncOfferException("Object unavailable for immediate access. Access Request required");
            }
            Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
            if (status == Response.Status.NOT_FOUND) {
                String payload = (String)response.readEntity(String.class);
                Optional<VitamError<?>> optionalVitamError = this.toVitamError(payload);
                if (optionalVitamError.isPresent()) {
                    VitamClientException vitamClientException = new VitamClientException(optionalVitamError.get().getMessage());
                    vitamClientException.setVitamError(optionalVitamError.get());
                    throw vitamClientException;
                }
                Optional<PurgedPersistentIdentifier> optionalPurgedPersistentIdentifier = this.toPurgedPersistentIdentifier(payload);
                if (optionalPurgedPersistentIdentifier.isPresent()) {
                    Response response2 = Response.status((Response.Status)status).entity((Object)payload).build();
                    return response2;
                }
            }
            this.check(response);
            Response response3 = response;
            return response3;
        }
        finally {
            if (response != null && Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
                response.close();
            }
        }
    }

    private Optional<VitamError<?>> toVitamError(String payload) {
        try {
            VitamError vitamError = (VitamError)JsonHandler.getFromString((String)payload, VitamError.class);
            if (vitamError.getHttpCode() == 0) {
                throw new InvalidParseOperationException("JsonHandler.getFromString not working as expected");
            }
            return Optional.of(vitamError);
        }
        catch (InvalidParseOperationException e) {
            return Optional.empty();
        }
    }

    private Optional<PurgedPersistentIdentifier> toPurgedPersistentIdentifier(String payload) {
        try {
            PurgedPersistentIdentifier purgedPersistentIdentifier = (PurgedPersistentIdentifier)JsonHandler.getFromString((String)payload, PurgedPersistentIdentifier.class);
            return Optional.of(purgedPersistentIdentifier);
        }
        catch (InvalidParseOperationException e) {
            return Optional.empty();
        }
    }

    @Override
    public RequestResponse<JsonNode> selectUnitsWithInheritedRules(VitamContext vitamContext, JsonNode selectQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/unitsWithInheritedRules").withHeaders(vitamContext.getHeaders()).withBody((Object)selectQuery).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public Response getAccessLog(VitamContext vitamContext, JsonNode params) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/storageaccesslog").withBody((Object)params).withHeaders(vitamContext.getHeaders()).withJsonOctet();
        return this.make(request);
    }

    @Override
    public RequestResponse<JsonNode> launchPreservation(VitamContext vitamContext, PreservationRequest preservationRequest) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/preservation").withHeaders(vitamContext.getHeaders()).withBody((Object)preservationRequest).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> startEliminationAnalysis(VitamContext vitamContext, EliminationRequestBody eliminationRequestBody) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/elimination/analysis").withHeaders(vitamContext.getHeaders()).withBody((Object)eliminationRequestBody, MISSING_ELIMINATION_REQUEST).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> startEliminationAction(VitamContext vitamContext, EliminationRequestBody eliminationRequestBody) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/elimination/action").withHeaders(vitamContext.getHeaders()).withBody((Object)eliminationRequestBody, MISSING_ELIMINATION_REQUEST).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> computedInheritedRules(VitamContext vitamContext, JsonNode updateQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/units/computedInheritedRules").withHeaders(vitamContext.getHeaders()).withBody((Object)updateQuery).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> deleteComputedInheritedRules(VitamContext vitamContext, JsonNode deleteComputedInheritedRulesQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/units/computedInheritedRules").withHeaders(vitamContext.getHeaders()).withBody((Object)deleteComputedInheritedRulesQuery).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    public RequestResponse transferReply(VitamContext vitamContext, InputStream transferReply) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transfers/reply").withHeaders(vitamContext.getHeaders()).withBody((Object)transferReply).withXMLContentType().withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    private void check(Response response) throws VitamClientException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        throw new VitamClientException(String.format("Error with the response, get status: '%d' and reason '%s'.", status.getStatusCode(), status.getReasonPhrase()));
    }
}

