/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.client;

import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AccessExternalClientMock;
import fr.gouv.vitam.access.external.client.AccessExternalClientRest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.external.client.VitamClientFactory;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfiguration;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;

public class AccessExternalClientFactory
extends VitamClientFactory<AccessExternalClient> {
    private static final String CONFIGURATION_FILENAME = "access-external-client.conf";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessExternalClientFactory.class);
    private static final AccessExternalClientFactory ACCESS_CLIENT_FACTORY = new AccessExternalClientFactory();
    private static final String RESOURCE_PATH = "/access-external/v1";

    protected AccessExternalClientFactory() {
        super((ClientConfiguration)AccessExternalClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static final AccessExternalClientFactory getInstance() {
        return ACCESS_CLIENT_FACTORY;
    }

    static final SecureClientConfiguration changeConfigurationFile(String configurationPath) {
        SecureClientConfiguration configuration = null;
        try {
            configuration = (SecureClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public AccessExternalClient getClient() {
        AccessExternalClient client;
        switch (this.getVitamClientType()) {
            case MOCK: {
                client = new AccessExternalClientMock();
                break;
            }
            case PRODUCTION: {
                client = new AccessExternalClientRest(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Log type unknown");
            }
        }
        return client;
    }

    public static void changeMode(ClientConfiguration configuration) {
        AccessExternalClientFactory.getInstance().initialisation(configuration, AccessExternalClientFactory.getInstance().getResourcePath());
    }

    public static void changeMode(String configurationFile) {
        SecureClientConfiguration configuration = AccessExternalClientFactory.changeConfigurationFile(configurationFile);
        AccessExternalClientFactory.getInstance().initialisation((ClientConfiguration)configuration, AccessExternalClientFactory.getInstance().getResourcePath());
    }
}

