/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.lifecycles.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientMock;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientRest;
import java.io.File;
import java.io.IOException;

public class LogbookLifeCyclesClientFactory
extends VitamClientFactory<LogbookLifeCyclesClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookLifeCyclesClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "logbook-client.conf";
    private static final LogbookLifeCyclesClientFactory LOGBOOK_LIFECYCLES_CLIENT_FACTORY = new LogbookLifeCyclesClientFactory();
    public static final String RESOURCE_PATH = "/logbook/v1";

    private LogbookLifeCyclesClientFactory() {
        super(LogbookLifeCyclesClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static final LogbookLifeCyclesClientFactory getInstance() {
        return LOGBOOK_LIFECYCLES_CLIENT_FACTORY;
    }

    public LogbookLifeCyclesClient getClient() {
        LogbookLifeCyclesClient client;
        switch (this.getVitamClientType()) {
            case MOCK: {
                client = new LogbookLifeCyclesClientMock();
                break;
            }
            case PRODUCTION: {
                client = new LogbookLifeCyclesClientRest(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Log type unknown");
            }
        }
        return client;
    }

    static final ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        } else if (configuration.getServerHost() == null || configuration.getServerHost().trim().isEmpty() || configuration.getServerPort() <= 0) {
            configuration = null;
        }
        return configuration;
    }

    public static final void changeMode(ClientConfiguration configuration) {
        LogbookLifeCyclesClientFactory.getInstance().initialisation(configuration, LogbookLifeCyclesClientFactory.getInstance().getResourcePath());
    }
}

