/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.common.bulkatomicupdate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.InternalActionKeysRetriever;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.iterables.CountingIterator;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryResultFailure;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkSelectQueryResultOK;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.BulkUpdateUnitReportKey;
import fr.gouv.vitam.metadata.common.bulkatomicupdate.QueryRestrictionConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class BulkSelectQueryParallelProcessor {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BulkSelectQueryParallelProcessor.class);
    private final MetaDataClient metadataClient;
    private final InternalActionKeysRetriever internalActionKeysRetriever;
    private final QueryRestrictionConverter queryRestrictionConverter;
    private final Consumer<BulkSelectQueryResultOK> successReporter;
    private final Consumer<BulkSelectQueryResultFailure> failureReporter;
    private final int threadPoolSize;
    private final int threadPoolQueueSize;
    private final int batchSize;
    private final AtomicInteger nbWarnings = new AtomicInteger(0);
    private final AtomicInteger nbOKs = new AtomicInteger(0);
    private final boolean allowInternalFieldsUpdate;

    public BulkSelectQueryParallelProcessor(MetaDataClient metadataClient, InternalActionKeysRetriever internalActionKeysRetriever, int threadPoolSize, int threadPoolQueueSize, int batchSize, Consumer<BulkSelectQueryResultOK> successReporter, Consumer<BulkSelectQueryResultFailure> failureReporter, QueryRestrictionConverter queryRestrictionConverter, boolean allowInternalFieldsUpdate) {
        this.metadataClient = metadataClient;
        this.internalActionKeysRetriever = internalActionKeysRetriever;
        this.queryRestrictionConverter = queryRestrictionConverter;
        this.successReporter = successReporter;
        this.failureReporter = failureReporter;
        this.threadPoolSize = threadPoolSize;
        this.threadPoolQueueSize = threadPoolQueueSize;
        this.batchSize = batchSize;
        this.allowInternalFieldsUpdate = allowInternalFieldsUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Iterator<JsonNode> queryIterator) throws InvalidParseOperationException {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String processId = VitamThreadUtils.getVitamSession().getRequestId();
        CountingIterator queryWithIndexIterator = new CountingIterator(queryIterator);
        UnmodifiableIterator queriesBulkIterator = Iterators.partition((Iterator)queryWithIndexIterator, (int)this.batchSize);
        AtomicBoolean fatalErrorOccurred = new AtomicBoolean(false);
        AtomicBoolean koErrorOccurred = new AtomicBoolean(false);
        ThreadPoolExecutor executor = ExecutorUtils.createScalableBatchExecutorService((int)this.threadPoolSize, (int)this.threadPoolQueueSize);
        try {
            while (queriesBulkIterator.hasNext() && !fatalErrorOccurred.get()) {
                List bulkQueriesToProcess = (List)queriesBulkIterator.next();
                executor.submit(() -> {
                    VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenantId));
                    VitamThreadUtils.getVitamSession().setRequestId(processId);
                    if (fatalErrorOccurred.get() || koErrorOccurred.get()) {
                        throw new CancellationException("Job cancelled");
                    }
                    try {
                        this.processBulkQueries(bulkQueriesToProcess);
                    }
                    catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataDocumentSizeException | IllegalArgumentException e) {
                        koErrorOccurred.set(true);
                        LOGGER.error("An error occurred during bulk select query execution", e);
                    }
                    catch (Exception e) {
                        fatalErrorOccurred.set(true);
                        LOGGER.error("An unexpected error occurred during bulk select query execution", (Throwable)e);
                    }
                }, executor);
            }
        }
        finally {
            this.awaitExecutorTermination(executor);
        }
        if (koErrorOccurred.get()) {
            throw new InvalidParseOperationException("One or more KO errors occurred during bulk select query execution");
        }
        if (fatalErrorOccurred.get()) {
            throw new VitamRuntimeException("One or more FATAL errors occurred during bulk select query execution");
        }
    }

    private void processBulkQueries(List<CountingIterator.EntryWithIndex<JsonNode>> bulkQueriesToProcess) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException, InvalidCreateOperationException {
        List<CountingIterator.EntryWithIndex<JsonNode>> validQueries = this.reportAndFilterInvalidQueries(bulkQueriesToProcess);
        List<JsonNode> executableQueries = this.transformQueries(validQueries);
        List<List<String>> queriesResultUnitIds = this.bulkExecuteSelectQueries(this.metadataClient, executableQueries);
        this.handleResults(validQueries, queriesResultUnitIds);
    }

    private List<CountingIterator.EntryWithIndex<JsonNode>> reportAndFilterInvalidQueries(List<CountingIterator.EntryWithIndex<JsonNode>> bulkQueriesToProcess) {
        if (this.allowInternalFieldsUpdate) {
            return bulkQueriesToProcess;
        }
        ArrayList<CountingIterator.EntryWithIndex<JsonNode>> validQueries = new ArrayList<CountingIterator.EntryWithIndex<JsonNode>>();
        for (CountingIterator.EntryWithIndex<JsonNode> queryToProcess : bulkQueriesToProcess) {
            List internalKeyFields = this.internalActionKeysRetriever.getInternalActionKeyFields((JsonNode)queryToProcess.getValue());
            if (!internalKeyFields.isEmpty()) {
                String message = String.format(BulkUpdateUnitReportKey.INVALID_DSL_QUERY.getMessage() + " : '%s'", String.join((CharSequence)", ", internalKeyFields));
                this.reportQueryError(queryToProcess, BulkUpdateUnitReportKey.INVALID_DSL_QUERY, message);
                continue;
            }
            validQueries.add(queryToProcess);
        }
        return validQueries;
    }

    private List<List<String>> bulkExecuteSelectQueries(MetaDataClient metadataClient, List<JsonNode> executableQueries) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        if (executableQueries.isEmpty()) {
            return Collections.emptyList();
        }
        List queriesResponses = metadataClient.selectUnitsBulk(executableQueries);
        if (queriesResponses.size() != executableQueries.size()) {
            throw new IllegalStateException(String.format("Partial response for selectUnitsBulk. Expected %d. Got %d", executableQueries.size(), queriesResponses.size()));
        }
        return queriesResponses.stream().map(RequestResponseOK::getResults).map(resultSet -> resultSet.stream().map(this::parseUnitId).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<JsonNode> transformQueries(List<CountingIterator.EntryWithIndex<JsonNode>> bulkQueriesToProcess) throws InvalidParseOperationException, InvalidCreateOperationException {
        ArrayList<JsonNode> executableQueries = new ArrayList<JsonNode>();
        for (CountingIterator.EntryWithIndex<JsonNode> jsonNodeEntryWithIndex : bulkQueriesToProcess) {
            JsonNode query = (JsonNode)jsonNodeEntryWithIndex.getValue();
            ObjectNode jsonNodes = this.computeModifiedSelectQuery(query);
            executableQueries.add((JsonNode)jsonNodes);
        }
        return executableQueries;
    }

    private ObjectNode computeModifiedSelectQuery(JsonNode originalQuery) throws InvalidParseOperationException, InvalidCreateOperationException {
        JsonNode securedQueryNode = this.queryRestrictionConverter.convert(originalQuery);
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(securedQueryNode);
        SelectMultiQuery multiQuery = parser.getRequest();
        multiQuery.getRoots().clear();
        multiQuery.setLimitFilter(0L, 2L);
        multiQuery.addUsedProjection(new String[]{VitamFieldsHelper.id()});
        return multiQuery.getFinalSelect();
    }

    private String parseUnitId(JsonNode unitJson) {
        return unitJson.get(VitamFieldsHelper.id()).textValue();
    }

    private void handleResults(List<CountingIterator.EntryWithIndex<JsonNode>> bulkQueriesToProcess, List<List<String>> queriesResultUnitIds) {
        for (int i = 0; i < bulkQueriesToProcess.size(); ++i) {
            CountingIterator.EntryWithIndex<JsonNode> queryToProcess = bulkQueriesToProcess.get(i);
            List<String> unitIds = queriesResultUnitIds.get(i);
            int numberResults = unitIds.size();
            if (numberResults == 0) {
                this.reportQueryError(queryToProcess, BulkUpdateUnitReportKey.UNIT_NOT_FOUND, BulkUpdateUnitReportKey.UNIT_NOT_FOUND.getMessage());
                continue;
            }
            if (numberResults >= 2) {
                this.reportQueryError(queryToProcess, BulkUpdateUnitReportKey.TOO_MANY_UNITS_FOUND, BulkUpdateUnitReportKey.TOO_MANY_UNITS_FOUND.getMessage());
                continue;
            }
            String unitId = unitIds.get(0);
            this.reportQueryOK(unitId, (JsonNode)queryToProcess.getValue(), queryToProcess.getIndex());
        }
    }

    private synchronized void reportQueryOK(String unitId, JsonNode originalQuery, int queryIndex) {
        this.nbOKs.incrementAndGet();
        this.successReporter.accept(new BulkSelectQueryResultOK(queryIndex, originalQuery, unitId));
    }

    private synchronized void reportQueryError(CountingIterator.EntryWithIndex<JsonNode> queryToProcess, BulkUpdateUnitReportKey reportKey, String message) {
        this.nbWarnings.incrementAndGet();
        this.failureReporter.accept(new BulkSelectQueryResultFailure(queryToProcess.getIndex(), (JsonNode)queryToProcess.getValue(), reportKey, message));
    }

    public int getNbWarnings() {
        return this.nbWarnings.get();
    }

    public int getNbOKs() {
        return this.nbOKs.get();
    }

    private void awaitExecutorTermination(ThreadPoolExecutor executor) {
        try {
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new VitamRuntimeException("Awaiting bulk atomic update jobs interrupted", (Throwable)e);
        }
    }
}

