/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.administration.core;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.administration.core.LfcTraceabilityType;
import fr.gouv.vitam.logbook.common.model.LifecycleTraceabilityStatus;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.exception.LogbookException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.lifecycles.api.LogbookLifeCycles;
import fr.gouv.vitam.logbook.operations.api.LogbookOperations;
import fr.gouv.vitam.processing.common.ProcessingEntry;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class LogbookLFCAdministration {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookLFCAdministration.class);
    private final LogbookOperations logbookOperations;
    private final LogbookLifeCycles logbookLifeCycles;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final int lifecycleTraceabilityTemporizationDelayInSeconds;
    private final int traceabilityExpirationInSeconds;
    private final int lifecycleTraceabilityMaxEntries;

    public LogbookLFCAdministration(LogbookOperations logbookOperations, LogbookLifeCycles logbookLifeCycles, ProcessingManagementClientFactory processingManagementClientFactory, WorkspaceClientFactory workspaceClientFactory, Integer lifecycleTraceabilityTemporizationDelay, Integer lifecycleTraceabilityMaxRenewalDelay, ChronoUnit lifecycleTraceabilityMaxRenewalDelayUnit, Integer lifecycleTraceabilityMaxEntries) {
        this.logbookOperations = logbookOperations;
        this.logbookLifeCycles = logbookLifeCycles;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.lifecycleTraceabilityTemporizationDelayInSeconds = LogbookLFCAdministration.validateAndGetLifecycleTraceabilityTemporizationDelay(lifecycleTraceabilityTemporizationDelay);
        ParametersChecker.checkParameter((String)"Missing max renewal delay or unit", (Object[])new Object[]{lifecycleTraceabilityMaxRenewalDelay, lifecycleTraceabilityMaxRenewalDelayUnit});
        ParametersChecker.checkValue((String)"Invalid max renewal delay", (long)lifecycleTraceabilityMaxRenewalDelay.intValue(), (long)1L);
        this.traceabilityExpirationInSeconds = (int)Duration.of(lifecycleTraceabilityMaxRenewalDelay.intValue(), lifecycleTraceabilityMaxRenewalDelayUnit).toSeconds();
        this.lifecycleTraceabilityMaxEntries = LogbookLFCAdministration.validateAndGetLifecycleTraceabilityMaxEntries(lifecycleTraceabilityMaxEntries);
    }

    private static int validateAndGetLifecycleTraceabilityTemporizationDelay(Integer lifecycleTraceabilityTemporizationDelay) {
        if (lifecycleTraceabilityTemporizationDelay == null) {
            return 0;
        }
        if (lifecycleTraceabilityTemporizationDelay < 0) {
            throw new IllegalArgumentException("Temporization delay cannot be negative");
        }
        return lifecycleTraceabilityTemporizationDelay;
    }

    private static int validateAndGetLifecycleTraceabilityMaxEntries(Integer lifecycleTraceabilityMaxEntries) {
        if (lifecycleTraceabilityMaxEntries == null) {
            return 0;
        }
        if (lifecycleTraceabilityMaxEntries <= 0) {
            throw new IllegalArgumentException("Max traceability events cannot be negative");
        }
        return lifecycleTraceabilityMaxEntries;
    }

    public synchronized boolean generateSecureLogbookLFC(GUID traceabilityOperationGUID, LfcTraceabilityType lfcTraceabilityType) throws VitamException {
        LogbookOperation lastLfcTraceabilityOperationWithZip;
        Contexts workflowContext = this.getWorkflowContext(lfcTraceabilityType);
        if (this.isTraceabilityInProgress(workflowContext)) {
            LOGGER.error("There is another traceability operation in progress...");
            return false;
        }
        LogbookOperation lastLfcTraceabilityOperation = this.getLastTraceability(lfcTraceabilityType);
        if (!this.isNewTraceabilityRequired(lfcTraceabilityType, lastLfcTraceabilityOperation, lastLfcTraceabilityOperationWithZip = this.getLastTraceabilityWithZip(lfcTraceabilityType, lastLfcTraceabilityOperation))) {
            LOGGER.info("Traceability operation not required...");
            return false;
        }
        this.startTraceabilityWorkflow(traceabilityOperationGUID, workflowContext);
        return true;
    }

    private boolean isTraceabilityInProgress(Contexts workflowContext) throws VitamClientException {
        try (ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();){
            ProcessQuery query = new ProcessQuery();
            query.setStates(Arrays.stream(ProcessState.values()).filter(state -> state.compareTo((Enum)ProcessState.COMPLETED) < 0).map(Enum::name).collect(Collectors.toList()));
            query.setWorkflows(List.of(workflowContext.getEventType()));
            RequestResponse processDetailRequestResponse = processManagementClient.listOperationsDetails(query);
            if (!processDetailRequestResponse.isOk()) {
                VitamError error = (VitamError)processDetailRequestResponse;
                throw new VitamClientException("Could not check concurrent workflows " + error.getDescription() + " - " + error.getMessage());
            }
            boolean bl = !((RequestResponseOK)processDetailRequestResponse).getResults().isEmpty();
            return bl;
        }
    }

    private LogbookOperation getLastTraceability(LfcTraceabilityType lfcTraceabilityType) throws VitamException {
        return this.logbookOperations.findLastLifecycleTraceabilityOperation(this.getWorkflowContext(lfcTraceabilityType).getEventType(), false);
    }

    private LogbookOperation getLastTraceabilityWithZip(LfcTraceabilityType lfcTraceabilityType, LogbookOperation lastLfcTraceabilityOperation) throws VitamException {
        if (lastLfcTraceabilityOperation == null) {
            LOGGER.info("No traceability with Zip. This is the very first traceability operation");
            return null;
        }
        TraceabilityEvent traceabilityEvent = this.getTraceabilityEvent(lastLfcTraceabilityOperation);
        if (traceabilityEvent != null && traceabilityEvent.getFileName() != null) {
            LOGGER.info("Last traceability operation " + lastLfcTraceabilityOperation.getId() + "has a Zip.");
            return lastLfcTraceabilityOperation;
        }
        return this.logbookOperations.findLastLifecycleTraceabilityOperation(this.getWorkflowContext(lfcTraceabilityType).getEventType(), true);
    }

    private boolean isNewTraceabilityRequired(LfcTraceabilityType lfcTraceabilityType, LogbookOperation lastLfcTraceabilityOperation, LogbookOperation lastLfcTraceabilityOperationWithZip) throws InvalidParseOperationException {
        if (lastLfcTraceabilityOperation == null) {
            LOGGER.info("Very first traceability operation. Traceability required");
            return true;
        }
        if (this.isLastTraceabilityOperationTooOld(lastLfcTraceabilityOperation)) {
            LOGGER.info(lfcTraceabilityType + " LFC traceability required. Last traceability operation is too old.");
            return true;
        }
        if (this.isMaxEntriesReached(lastLfcTraceabilityOperation)) {
            LOGGER.info("Previous traceability operation did not process all data set (MaxEntriesReached)");
            return true;
        }
        if (this.checkNewLifeCyclesSinceLastTraceabilityOperation(lfcTraceabilityType, lastLfcTraceabilityOperationWithZip)) {
            LOGGER.info(lfcTraceabilityType + " LFC traceability required. New LFCs found since last traceability operation");
            return true;
        }
        LOGGER.info("Skipping " + lfcTraceabilityType + " LFC traceability. No activity since last traceability operation");
        return false;
    }

    private boolean isLastTraceabilityOperationTooOld(LogbookOperation lastLfcTraceabilityOperation) {
        String evDateTimeStr = (String)lastLfcTraceabilityOperation.get((Object)LogbookMongoDbName.eventDateTime.getDbname());
        LocalDateTime lastTraceabilityDate = LocalDateUtil.parseMongoFormattedDate((String)evDateTimeStr);
        LocalDateTime lastTraceabilityOperationValidityDateTime = lastTraceabilityDate.plusSeconds(this.traceabilityExpirationInSeconds);
        return lastTraceabilityOperationValidityDateTime.isBefore(LocalDateUtil.now());
    }

    private boolean isMaxEntriesReached(LogbookOperation lastLfcTraceabilityOperation) throws InvalidParseOperationException {
        TraceabilityEvent lastLfcTraceabilityDetails = this.getTraceabilityEvent(lastLfcTraceabilityOperation);
        return lastLfcTraceabilityDetails != null && lastLfcTraceabilityDetails.isMaxEntriesReached();
    }

    private boolean checkNewLifeCyclesSinceLastTraceabilityOperation(LfcTraceabilityType lfcTraceabilityType, LogbookOperation lastLfcTraceabilityOperationWithZip) throws InvalidParseOperationException {
        LocalDateTime traceabilityStartDate = this.getTraceabilityStartDate(lastLfcTraceabilityOperationWithZip);
        LocalDateTime traceabilityEndDate = LocalDateUtil.now().minusSeconds(this.lifecycleTraceabilityTemporizationDelayInSeconds);
        switch (lfcTraceabilityType) {
            case Unit: {
                return this.logbookLifeCycles.checkUnitLifecycleEntriesExistenceByLastPersistedDate(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityStartDate), LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityEndDate));
            }
            case ObjectGroup: {
                return this.logbookLifeCycles.checkObjectGroupLifecycleEntriesExistenceByLastPersistedDate(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityStartDate), LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityEndDate));
            }
        }
        throw new IllegalStateException("Unexpected value: " + lfcTraceabilityType);
    }

    private LocalDateTime getTraceabilityStartDate(LogbookOperation lastLfcTraceabilityOperationWithZip) throws InvalidParseOperationException {
        LocalDateTime traceabilityStartDate;
        if (lastLfcTraceabilityOperationWithZip == null) {
            traceabilityStartDate = LogbookTraceabilityHelper.INITIAL_START_DATE;
        } else {
            TraceabilityEvent lastLfcTraceabilityWithZipEventDetails = this.getTraceabilityEvent(lastLfcTraceabilityOperationWithZip);
            if (lastLfcTraceabilityWithZipEventDetails == null) {
                throw new IllegalStateException("Last traceability with zip must have event details " + lastLfcTraceabilityOperationWithZip.getId());
            }
            traceabilityStartDate = LocalDateUtil.parseMongoFormattedDate((String)lastLfcTraceabilityWithZipEventDetails.getEndDate());
        }
        return traceabilityStartDate;
    }

    private void startTraceabilityWorkflow(GUID traceabilityOperationGUID, Contexts workflowContext) throws VitamClientException, InternalServerException, BadRequestException, LogbookException {
        this.createContainer(traceabilityOperationGUID.getId());
        try (ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();){
            LogbookOperationParameters logbookUpdateParametersStart = LogbookParameterHelper.newLogbookOperationParameters((GUID)traceabilityOperationGUID, (String)workflowContext.getEventType(), (GUID)traceabilityOperationGUID, (LogbookTypeProcess)LogbookTypeProcess.TRACEABILITY, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)workflowContext.getEventType(), (StatusCode)StatusCode.STARTED), (GUID)traceabilityOperationGUID);
            LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookUpdateParametersStart);
            this.logbookOperations.create(traceabilityOperationGUID.getId(), new LogbookOperationParameters[]{logbookUpdateParametersStart});
            try {
                ProcessingEntry processingEntry = new ProcessingEntry(traceabilityOperationGUID.getId(), workflowContext.name());
                processingEntry.getExtraParams().put(WorkerParameterName.lifecycleTraceabilityTemporizationDelayInSeconds.name(), Integer.toString(this.lifecycleTraceabilityTemporizationDelayInSeconds));
                processingEntry.getExtraParams().put(WorkerParameterName.lifecycleTraceabilityMaxEntries.name(), Integer.toString(this.lifecycleTraceabilityMaxEntries));
                processManagementClient.initVitamProcess(processingEntry);
                LOGGER.debug("Started Traceability in Resource");
                RequestResponse ret = processManagementClient.updateOperationActionProcess(ProcessAction.RESUME.getValue(), traceabilityOperationGUID.getId());
                if (Response.Status.ACCEPTED.getStatusCode() != ret.getStatus()) {
                    throw new VitamClientException("Process could not be executed");
                }
            }
            catch (BadRequestException | InternalServerException | VitamClientException e) {
                LOGGER.error(e);
                LogbookOperationParameters logbookUpdateParametersEnd = LogbookParameterHelper.newLogbookOperationParameters((GUID)traceabilityOperationGUID, (String)workflowContext.getEventType(), (GUID)traceabilityOperationGUID, (LogbookTypeProcess)LogbookTypeProcess.TRACEABILITY, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)workflowContext.getEventType(), (StatusCode)StatusCode.KO), (GUID)traceabilityOperationGUID);
                LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookUpdateParametersEnd);
                this.logbookOperations.update(traceabilityOperationGUID.getId(), new LogbookOperationParameters[]{logbookUpdateParametersEnd});
                throw e;
            }
        }
    }

    private Contexts getWorkflowContext(LfcTraceabilityType lfcTraceabilityType) {
        switch (lfcTraceabilityType) {
            case Unit: {
                return Contexts.UNIT_LFC_TRACEABILITY;
            }
            case ObjectGroup: {
                return Contexts.OBJECTGROUP_LFC_TRACEABILITY;
            }
        }
        throw new IllegalStateException("Unknown traceability type " + lfcTraceabilityType);
    }

    private TraceabilityEvent getTraceabilityEvent(LogbookOperation traceabilityOperation) throws InvalidParseOperationException {
        String evDetDataStr = (String)traceabilityOperation.get((Object)LogbookMongoDbName.eventDetailData.getDbname());
        return evDetDataStr == null ? null : (TraceabilityEvent)JsonHandler.getFromString((String)evDetDataStr, TraceabilityEvent.class);
    }

    private void createContainer(String containerName) throws VitamClientException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            workspaceClient.createContainer(containerName);
        }
        catch (ContentAddressableStorageServerException e) {
            throw new VitamClientException((Throwable)e);
        }
    }

    public LifecycleTraceabilityStatus checkLifecycleTraceabilityStatus(String operationId) throws VitamException, InvalidCreateOperationException {
        try (ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();){
            ItemStatus processStatus = processManagementClient.getOperationProcessStatus(operationId);
            boolean isCompleted = processStatus.getGlobalState() == ProcessState.COMPLETED;
            boolean isPaused = processStatus.getGlobalState() == ProcessState.PAUSE;
            boolean isOK = processStatus.getGlobalStatus() == StatusCode.OK;
            LifecycleTraceabilityStatus lifecycleTraceabilityStatus = new LifecycleTraceabilityStatus();
            lifecycleTraceabilityStatus.setCompleted(isCompleted);
            lifecycleTraceabilityStatus.setPaused(isPaused);
            lifecycleTraceabilityStatus.setOutcome(processStatus.getGlobalState().name() + "." + processStatus.getGlobalStatus().name());
            if (isCompleted && isOK) {
                Select selectQuery = new Select();
                selectQuery.setQuery((Query)QueryHelper.eq((String)LogbookMongoDbName.eventIdentifier.getDbname(), (String)operationId));
                List operations = this.logbookOperations.selectOperations((JsonNode)selectQuery.getFinalSelect());
                if (operations.isEmpty()) {
                    throw new LogbookNotFoundException("Could not find logbook operation " + operationId);
                }
                String evDetData = ((LogbookOperation)operations.get(0)).getString((Object)"evDetData");
                TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromString((String)evDetData, TraceabilityEvent.class);
                lifecycleTraceabilityStatus.setMaxEntriesReached(traceabilityEvent.getMaxEntriesReached());
            }
            LifecycleTraceabilityStatus lifecycleTraceabilityStatus2 = lifecycleTraceabilityStatus;
            return lifecycleTraceabilityStatus2;
        }
    }
}

